package gov.va.med.fee.controller;

import static org.hamcrest.Matchers.is;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.verifyNoMoreInteractions;
import static org.mockito.Mockito.when;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import static org.springframework.test.web.servlet.result.MockMvcResultHandlers.print;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.content;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.jsonPath;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

import java.util.Arrays;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;
import org.springframework.http.MediaType;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.servlet.mvc.method.annotation.ExceptionHandlerExceptionResolver;

import gov.va.med.fee.model.response.UserReqResponse;
import gov.va.med.fee.service.IUserRequestService;

@RunWith(MockitoJUnitRunner.class)
public class UserRequestControllerTest {
	private static final Logger logger = LogManager.getLogger(UserRequestControllerTest.class);
	
	private MockMvc mockMvc;
	
	@InjectMocks
	UserRequestController userRequestController;
	
	@Mock
	IUserRequestService userRequestService;
			
	@Before
	public void init() throws Exception {
		mockMvc = MockMvcBuilders.standaloneSetup(userRequestController).setHandlerExceptionResolvers(new ExceptionHandlerExceptionResolver()).build();
	}
	
	@Test
	public void testLoadRequestUser() throws Exception {
		String [] available_roles = new String[] {"FPPS_HELP_DESK","FEE_SUPERVISOR","FEE_VISN_PGM_MANAGER"};
		
		//String facLabel = "Visn: " + req.getVisnIdCd() + " / Facility: " + req.getVaFacilityCd() + req.getShortName();		
		String [] available_facilities = new String[] {"Visn: 16 / Facility: 520 (BILOXI MS)","Visn: 16 / Facility: 564 (Fayetteville NC VAMC)"};
		UserReqResponse response = new UserReqResponse(Arrays.asList(available_roles), Arrays.asList(available_facilities));
		
		when(userRequestService.loadUserRequestForm()).thenReturn(response);
		
		mockMvc.perform(get("/api/v1/userRequest/form")).andDo(print()).andExpect(status().isOk())
				.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE))
				.andExpect(jsonPath("$.available_roles[0]", is("FPPS_HELP_DESK")))
				.andExpect(jsonPath("$.available_roles[1]", is("FEE_SUPERVISOR")))
				.andExpect(jsonPath("$.available_roles[2]", is("FEE_VISN_PGM_MANAGER")))
				.andExpect(jsonPath("$.available_facilities[0]", is("Visn: 16 / Facility: 520 (BILOXI MS)")))
				.andExpect(jsonPath("$.available_facilities[1]", is("Visn: 16 / Facility: 564 (Fayetteville NC VAMC)")));
		
		verify(userRequestService, times(1)).loadUserRequestForm();
		verifyNoMoreInteractions(userRequestService);
	}
	
	
	@Test 
	public void testLoadRequestModifyUser() throws Exception {
		// set up
		long appUserRequestId = 1L;
		String current_user_name = "VHAISMBAIAHBBB";
		String window_nt_name = "DNS   ABBA";
		String last_name = "Jackson";
		String middle_name = "B";
		String first_name = "Jacky";
		String phone = "9876543210";
		String email = "PII                ";
		boolean enabled = Boolean.TRUE;
		String disable_comments = "CCSE";
		
		String [] available_roles = new String[] {"FPPS_HELP_DESK"};
		String [] available_facilities = new String[] {"Visn: 16 / Facility: 520 (BILOXI MS)","Visn: 16 / Facility: 564 (Fayetteville NC VAMC)","Visn: 16 / Facility: 565 (Fayetteville NC VAMC)"};
		String [] request_roles = new String[] {};// "FPPS_HELP_DESK"};
		String [] request_facilities = new String[] {"Visn: 16 / Facility: 520 (BILOXI MS)","Visn: 16 / Facility: 564 (Fayetteville NC VAMC)"};
		
		UserReqResponse resp = new UserReqResponse(window_nt_name, last_name, first_name, middle_name,
				phone, email, enabled, disable_comments, Arrays.asList(request_roles), Arrays.asList(request_facilities));
		resp.setAvailable_roles( Arrays.asList(available_roles));
		resp.setAvailable_facilities(Arrays.asList(available_facilities));
		
		
		when(userRequestService.loadModifyUserRequestFormByName(current_user_name)).thenReturn(resp);
		
		mockMvc.perform(get("/api/v1/userRequest/form/{userName}", current_user_name)).andDo(print()).andExpect(status().isOk())
		.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		// .andExpect(jsonPath("$.result", is(1)));
	}		
	
	/*@Test
	public void test_requestAddUser() throws Exception {
		// set up
		String current_user_name = "VHAISMBAIAHBBB";
		String window_nt_name = "DNS   ABBA";
		String last_name = "Jackson";
		String middle_name = "B";
		String first_name = "Jacky";
		String phone = "9876543210";
		String email = "PII                ";
		boolean enabled = Boolean.TRUE;
		
		String [] request_roles = new String[] {};// "FPPS_HELP_DESK"};
		String [] request_facilities = new String[] {"Visn: 16 / Facility: 520 (BILOXI MS)","Visn: 16 / Facility: 564 (Fayetteville NC VAMC)"};
		
		UserReqRequest req = new UserReqRequest(current_user_name, window_nt_name, last_name, first_name, middle_name, phone, 
				email, enabled, Arrays.asList(request_roles), Arrays.asList(request_facilities));
		
		when(userRequestService.requestAddUser(req)).thenReturn(1);
		
		mockMvc.perform(post("/api/v1/userRequest/").contentType(MediaType.APPLICATION_JSON)
				.content(getRequestJson(req))).andDo(print());
		
		verify(userRequestService, times(1)).requestAddUser(req);
	}
	
	private String getRequestJson(Object request) {
		String requestJson = null;
		try {
			ObjectMapper mapper = new ObjectMapper();
		    mapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
		    ObjectWriter ow = mapper.writer().withDefaultPrettyPrinter();
			requestJson = ow.writeValueAsString(request);
			System.out.println("requestJson - " + requestJson);
		
		} catch (JsonProcessingException e) {
			logger.error("testRequestAddUser JsonProcessingException -- ");
			e.printStackTrace();
		
		}
		
		return requestJson;
	}*/
}
