package gov.va.med.fee.controller;

import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.post;
import static org.springframework.test.web.servlet.result.MockMvcResultHandlers.print;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.mockito.runners.MockitoJUnitRunner;
import org.springframework.http.MediaType;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;

import gov.va.med.fee.model.request.CodeLookupRequest;
import gov.va.med.fee.model.response.CodeLookupResponse;
import gov.va.med.fee.model.response.GenericResponse;
import gov.va.med.fee.service.ICodeLookupService;

/**
 * 
 * @author Muneshwar Baiah
 *
 */

@RunWith(MockitoJUnitRunner.class)
public class CodeLookupControllerTest {
	private MockMvc mockMvc;
	public static final MediaType APPLICATION_JSON_UTF8 = new MediaType(MediaType.APPLICATION_JSON.getType(), MediaType.APPLICATION_JSON.getSubtype(), Charset.forName("utf8"));

	@Mock
	private ICodeLookupService codeLookupServiceMock;
	
	@InjectMocks
	private CodeLookupController codeLookupController;

	@Before
	public void init() throws Exception {
		MockitoAnnotations.initMocks(this);
		mockMvc = MockMvcBuilders.standaloneSetup(codeLookupController).build();
	}
	
	/**
	 * Unit test for getting medical codes
	 * @throws Exception
	 */
	@Test
	public void getMedicalCodesSuccess() throws Exception {
		
		CodeLookupRequest codeLookupRequest = new CodeLookupRequest();
		codeLookupRequest.setCode("0000183329");
		codeLookupRequest.setCodeType("NDC CODES");
		codeLookupRequest.setDescending(false);
		codeLookupRequest.setPageNumber(1);
		codeLookupRequest.setPageSize(1);
		codeLookupRequest.setSortColumn("code");
		
		GenericResponse response = new GenericResponse(1,100,"MEDICAL_CD",100L);	
		
		List<CodeLookupResponse> medicalCodeList= new ArrayList<CodeLookupResponse>();
		CodeLookupResponse medicalCodeResponse = new CodeLookupResponse();
		medicalCodeResponse.setCodeType("NDC CODES");
		medicalCodeResponse.setDrugExempt("Drug Exemption");
		medicalCodeResponse.setExpirationDate(null);
		medicalCodeResponse.setStartDate(null);
		medicalCodeResponse.setCode("0000183329");
		medicalCodeResponse.setDescription("25 MG TAB - MECLIZINE HCL TABLETS ( HJ HARKINS CO INC )");
		
		medicalCodeList.add(medicalCodeResponse);
		response.setResponse(medicalCodeList);
		
		ObjectMapper mapper = new ObjectMapper();
	    mapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
	    ObjectWriter ow = mapper.writer().withDefaultPrettyPrinter();
	    String requestJson=ow.writeValueAsString(codeLookupRequest);
		

		mockMvc.perform(post("/api/v1/tools/medicalCodes").contentType(MediaType.APPLICATION_JSON).content(requestJson)).andDo(print())
		.andExpect(status().isOk());
				
	}
	
	/**
	 * Unit test for getting diagnosis codes
	 * @throws Exception
	 */
	@Test
	public void getDiagnosisCodesSuccess() throws Exception {
		
		CodeLookupRequest codeLookupRequest = new CodeLookupRequest();
		codeLookupRequest.setCode("0000183329");
		codeLookupRequest.setCodeType("NDC CODES");
		codeLookupRequest.setDescending(false);
		codeLookupRequest.setPageNumber(1);
		codeLookupRequest.setPageSize(1);
		codeLookupRequest.setSortColumn("code");
		
		GenericResponse response = new GenericResponse(1,100,"ICD_CODE",100L);	
		
		List<CodeLookupResponse> diagnosisCodeList= new ArrayList<CodeLookupResponse>();
		CodeLookupResponse diagnosisCodeResponse = new CodeLookupResponse();
		diagnosisCodeResponse.setCodeType("1");
		diagnosisCodeResponse.setDrugExempt("Drug Exemption");
		diagnosisCodeResponse.setExpirationDate(null);
		diagnosisCodeResponse.setStartDate(null);
		diagnosisCodeResponse.setCode("T40.4");
		diagnosisCodeResponse.setDescription("Poisoning by, adverse effect of and underdosing of other synthetic narcotics");
		
		diagnosisCodeList.add(diagnosisCodeResponse);
		response.setResponse(diagnosisCodeList);

		ObjectMapper mapper = new ObjectMapper();
	    mapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
	    ObjectWriter ow = mapper.writer().withDefaultPrettyPrinter();
	    String requestJson=ow.writeValueAsString(codeLookupRequest);
	    
		mockMvc.perform(post("/api/v1/tools/diagnosisCodes").contentType(MediaType.APPLICATION_JSON).content(requestJson)).andDo(print())
		.andExpect(status().isOk());
				
	}
	
}
