package gov.va.med.fee.controller;

import static org.mockito.Mockito.when;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import static org.springframework.test.web.servlet.result.MockMvcResultHandlers.print;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.content;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

import java.util.HashSet;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.mockito.runners.MockitoJUnitRunner;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import gov.va.med.fee.exceptions.GenericException;
import gov.va.med.fee.model.response.AuthenticationParamResponse;
import gov.va.med.fee.model.response.UserInfoResponse;
import gov.va.med.fee.model.response.UserStationDetails;
import gov.va.med.fee.service.IAuthenticatorService;
import net.minidev.json.JSONObject;


/**
 * 
 * @author Mahilet Demisse
 *
 */

@RunWith(MockitoJUnitRunner.class)
public class AuthenticatorControllerTest {

	private MockMvc mockMvc;

	@Mock
	private IAuthenticatorService authenticatorService;

	@InjectMocks
	private AuthenticatorController authenticatorController;

	@Before
	public void init() throws Exception {
		MockitoAnnotations.initMocks(this);
		mockMvc = MockMvcBuilders.standaloneSetup(authenticatorController).build();
	}

	/**
	 * @throws Exception
	 */
	@Test
	public void getUserRoles() throws Exception {
		
		// creating guid param
		String guid = "45bRjsfHGHKmLHkksf76";
		
		//creating the response
		UserInfoResponse userInfoResponse = new UserInfoResponse();
		userInfoResponse.setUserName("DNS   DEMIS");
		userInfoResponse.setLastLogin("11/02/2017 10:27:12");
		
		// creating the roles
		Set<String> userRoles = new HashSet<String>();
		userRoles.add("ADMIN");
		userInfoResponse.setUserRoles(userRoles);
		
		// creating the permssions
		JSONObject permissions = new JSONObject();
		userInfoResponse.setPermissions(permissions);
		
		// creating user facility
		UserStationDetails userFacilityData = new UserStationDetails();
		userInfoResponse.setUserFacilityData(userFacilityData);
	
		// mocking service calls
		when(authenticatorService.authenticate(guid)).thenReturn(true);
		when(authenticatorService.getUserRoles()).thenReturn(userInfoResponse);
		
		
		try {
			mockMvc.perform(get("/api/v1/roles").param("guid", guid)).andDo(print()).andExpect(status().isOk())
			.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));

		} catch (Exception e) {
			e.printStackTrace();
		}
	

	}

	
	/*
	 * @throws Exception
	 */
	@Test
	public void getAuthParams() throws Exception {
		
		// creating seesionId
		String sessionId = "abc";
		
		// creating Auth response
		AuthenticationParamResponse authenticationParamResponse = null;
		
	
		// mocking service calls 
		when(authenticatorService.getAuthParams(sessionId)).thenReturn(authenticationParamResponse);
		
		try {
			mockMvc.perform(get("/api/v1/authParams")).andDo(print()).andExpect(status().isOk());
			
		} catch (Exception e) {
			e.printStackTrace();
		}
		
	}
}
