/**
 * 
 */
package gov.va.med.fee.validators;

import java.util.InputMismatchException;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;

import gov.va.med.fee.constants.ClaimDetailsConstants;
import gov.va.med.fee.exceptions.GenericException;

/**
 * @author Vamsi Krishna Gangarapu
 *
 */
public class ClaimDetailsValidator {

	private static final Logger logger = LogManager.getLogger(ClaimDetailsValidator.class);

	/**
	 * @param claimIndex
	 * @return boolean value
	 * @throws GenericException
	 */
	public Boolean returnClaimNumber(String claimIndex) throws GenericException {
		Boolean isValid = false;
		try {
			if (claimIndex.matches("[0-9]+")) {
				//claimNumber = Long.valueOf(claimIndex).longValue();
				isValid = true;
				return isValid;
			} else {
				throw new GenericException(ClaimDetailsConstants.BAD_REQUEST, "Not a valid Claim Number", HttpStatus.BAD_REQUEST);
			}

		} catch (InputMismatchException  e) {
			logger.error("ClaimDetailsServiceImpl.getClaimDetailsByClaimIndex() internal_server_error for " + claimIndex
					+ " " + e);
			throw new GenericException(ClaimDetailsConstants.BAD_REQUEST, e.getMessage(), HttpStatus.BAD_REQUEST);
		}
	}

}
