/**
 * 
 */
package gov.va.med.fee.util;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

import gov.va.med.fee.exceptions.GenericException;
import gov.va.med.fee.model.response.ErrorResponse;



/**
 * @author Eyuel Taddese
 *
 */
@ControllerAdvice
public class ExceptionControllerAdvice {
	
	/*
	 * This Exception Handler will handle ClaimException thrown in the Application Layer
	 */
	@ExceptionHandler(GenericException.class)
	public ResponseEntity<ErrorResponse> exceptionHandlerRule(GenericException ex) {
		ErrorResponse error = new ErrorResponse();
		error.setErrorCode(ex.getErrorCode());
		error.setErrorDescription(ex.getErrorDescription());
		return new ResponseEntity<ErrorResponse>(error, ex.getHttpStatusCode());
	}
}
