/*
 *
 */
package gov.va.med.fee.util;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Properties;

import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.Message;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Email {

	private static final Logger logger = LogManager.getLogger(Email.class);

	String recipients[] = { "" };
	String subject = "";
	String message = "";
	String from = "PII                 ";

	public String postMail(String recipients[], String subject, String message, String from, boolean sendReadNotice,
			String readNoticeAddress) throws MessagingException, AddressException {
		
		boolean debug = false;
		String ret = "";
		// Set the host smtp address
		Properties props = new Properties();
		props.put("mail.smtp.host", "DNS        ");
		props.put("mail.host", "DNS        ");

		// create some properties and get the default Session
		Session session = Session.getInstance (props);
		session.setDebug(debug);

		// create a message
		Message msg = new MimeMessage(session);

		// set the from and to address
		InternetAddress addressFrom = new InternetAddress(from);
		msg.setFrom(addressFrom);

		InternetAddress[] addressTo = new InternetAddress[recipients.length];
		for (int i = 0; i < recipients.length; i++) {
			try {
				if (recipients[i] != null && !recipients[i].equals("")) {
					InternetAddress addressTemp = new InternetAddress(recipients[i]);
					addressTemp.validate();
					addressTo[i] = addressTemp;
					msg.setRecipients(Message.RecipientType.TO, addressTo);

					if (sendReadNotice) {
						msg.setHeader("Disposition-Notification-To", readNoticeAddress);
					}

					// Setting the Subject and Content Type
					msg.setSubject(subject);
					msg.setContent(message, "text/html");
					Transport.send(msg);

					GregorianCalendar gc = new GregorianCalendar();
					String dts = (gc.get(Calendar.MONTH) + 1) + "/" + gc.get(Calendar.DAY_OF_MONTH) + "/"
							+ gc.get(Calendar.YEAR) + " at " + gc.get(Calendar.HOUR_OF_DAY) + ":"
							+ gc.get(Calendar.MINUTE) + ":" + gc.get(Calendar.SECOND);
					ret += "message sent at " + dts;
				}
			} catch (AddressException ae) {
				ret += "AddressException ERROR: " + ae.getMessage();
				logger.error(ae.getMessage(), ae);
			} catch (MessagingException me) {
				ret += "MessagingException Error: " + me.getMessage();
				logger.error(me.getMessage(), me);
			} catch (Exception e) {
				ret += "Exception Error: " + e.getMessage();
				logger.error(e.getMessage(), e);
			}
		}

		return ret;
	}
}
