/**
 *  @author Baeldung(Spring Security OAuth)
 *
 */
package gov.va.med.fee.util;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.stereotype.Component;

@Component
public class CorsFilter implements Filter {

	@Override
	public void init(FilterConfig filterConfig) throws ServletException {
		
	}

	@Override
	public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain)
			throws IOException, ServletException {
		final HttpServletResponse responseResult = (HttpServletResponse) request;
		responseResult.setHeader("Access-Control-Allow-Origin", "*");
		responseResult.setHeader("Access-Control-Allow-Methods", "POST,PUT,GET,OPTIONS,DELETE");
		responseResult.setHeader("Access-Control-Allow-Headers", "Authorization, Content-Type");
		responseResult.setHeader("Access-Control-Max-Age", "3600");
		if("OPTIONS".equalsIgnoreCase(((HttpServletRequest) request).getMethod())) {
			responseResult.setStatus(HttpServletResponse.SC_OK);
		} else {
			chain.doFilter(request, response);
		}
	}

	@Override
	public void destroy() {
		
	}

}
