/**
 * 
 */
package gov.va.med.fee.service.impl;

import java.text.SimpleDateFormat;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import gov.va.med.domain.fee.Claim;
import gov.va.med.domain.fee.PersonInfo;
import gov.va.med.fee.dao.IVeteranInfoRepository;
import gov.va.med.fee.exceptions.GenericException;
import gov.va.med.fee.model.response.VeteranInfoResponse;
import gov.va.med.fee.service.IVeteranInfoService;

/**
 * @author Vamsi Krishna Gangarapu
 *
 */
@Service
public class VeteranInfoServiceImpl implements IVeteranInfoService {

	private static final Logger logger = LogManager.getLogger(VeteranInfoServiceImpl.class);

	@Autowired
	IVeteranInfoRepository iPersonInfoRepository;

	/**
	 * 
	 * @param iPersonInfoRepository
	 */
	public void setiPersonInfoRepository(IVeteranInfoRepository iPersonInfoRepository) {
		this.iPersonInfoRepository = iPersonInfoRepository;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.fee.service.IVeteranInfoService#getVeteranInfo(gov.va.med.domain.fee.Claim)
	 */
	@Override
	public VeteranInfoResponse getVeteranInfo(Claim claim) throws GenericException {
		logger.info("VeteranInfoServiceImpl.getVeteranInfo() getting details for claim index :" + claim.getClaimIndex());
		PersonInfo personInfo = new PersonInfo();
		VeteranInfoResponse veteranInfoResponse = null;
		try {
			logger.info("VeteranInfoServiceImpl.getVeteranInfo() invoking the iPersonInfoRepository.findOneByClaimId for claim index :"+claim.getClaimIndex());
			personInfo = iPersonInfoRepository.findOneByClaimId(claim.getClaimIndex());
		} catch (Exception ex) {
			logger.error("VeteranInfoServiceImpl.getPersonInfo : internal_server_error for " + claim.getClaimIndex() + " "
					+ ex);
			//return veteranInfoResponse;
		}
		
		if (personInfo != null) {
			veteranInfoResponse = new VeteranInfoResponse();
			logger.info("VeteranInfoServiceImpl.getVeteranInfo() veteran info found for " + claim.getClaimIndex());
			logger.debug("VeteranInfoServiceImpl.getVeteranInfo() constructing the response using personInfo :"
					+ personInfo.toString());
			veteranInfoResponse = new VeteranInfoResponse();
			SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
			String birthDate = dateFormat.format(personInfo.getBirthDate());
			veteranInfoResponse.setPersonInfoId(personInfo.getPersonInfoId());
			veteranInfoResponse.setLastName(personInfo.getLastName());
			veteranInfoResponse.setFirstName(personInfo.getFirstName());
			veteranInfoResponse.setMiddleName(personInfo.getMiddleName());
			veteranInfoResponse.setAddressLine1(personInfo.getAddressLine1());
			veteranInfoResponse.setAddressLine2(personInfo.getAddressLine2());
			veteranInfoResponse.setCity(personInfo.getCity());
			veteranInfoResponse.setState(personInfo.getState());
			veteranInfoResponse.setZipCode(personInfo.getZipCode());
			veteranInfoResponse.setBirthDate(birthDate);
			veteranInfoResponse.setGender(personInfo.getGender());
			
			logger.debug(
					"VeteranInfoServiceImpl.getVeteranInfo() personInfo response is :" + veteranInfoResponse.toString());
		}
		
		logger.info("VeteranInfoServiceImpl.getVeteranInfo() returning back to the controller");
		return veteranInfoResponse;
	}

}
