package gov.va.med.fee.service.impl;

import java.util.ArrayList;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import gov.va.med.fee.dao.IUserSearchRepository;
import gov.va.med.fee.exceptions.GenericException;
import gov.va.med.fee.model.request.UserSearchRequest;
import gov.va.med.fee.model.response.UserSearchPage;
import gov.va.med.fee.model.response.UserSearchResponse;
import gov.va.med.fee.service.IUserSearchService;

@Service
public class UserSearchServiceImpl implements IUserSearchService {
	private static final Logger logger = LogManager.getLogger(UserSearchServiceImpl.class);
	
	@Autowired
	IUserSearchRepository iUserSearchRepository;
	
	@Override
	public UserSearchPage searchUser(UserSearchRequest userSearchRequest) throws GenericException {
		
		List<UserSearchResponse> userSearchResponseResult = new ArrayList<UserSearchResponse>();
		UserSearchPage userSearchPage = new UserSearchPage();
		
		try {
			userSearchResponseResult = iUserSearchRepository.searchUsers(userSearchRequest);
			
			if(!userSearchResponseResult.isEmpty()) {
				userSearchPage.setUsersfromSearch(userSearchResponseResult);
			}
			
			if(userSearchResponseResult.isEmpty()) {
				userSearchPage.setUsersfromSearch(userSearchResponseResult);
				logger.info("UserSearchServiceImpl.searchUser(): user_search_info_not_found " + 
						userSearchRequest.toString());
				
				logger.error("UserSearchServiceImpl.searchUser(): user_search_info_not_found " +
						userSearchRequest.toString());
			}
			
		} catch (Exception e) {
			logger.error("UserSearchServiceImpl.searchUser(): user_search_info_not_found " +
					userSearchRequest.toString());
		}
		
		return userSearchPage;
	}
}
