/**
 * 
 */
package gov.va.med.fee.service.impl;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

import gov.va.med.domain.fee.AdjustmentGroup;
import gov.va.med.domain.fee.AdjustmentReason;
import gov.va.med.domain.fee.Claim;
import gov.va.med.domain.fee.FeeClaimPaymentLines;
import gov.va.med.domain.fee.FeeClaimPayments;
import gov.va.med.fee.constants.ClaimDetailsConstants;
import gov.va.med.fee.dao.IAdjustmentGroupRepository;
import gov.va.med.fee.dao.IAdjustmentReasonRepository;
import gov.va.med.fee.dao.IClaimPaymentRepository;
import gov.va.med.fee.dao.IClaimRepository;
import gov.va.med.fee.dao.IFeeClaimPaymentLines;
import gov.va.med.fee.dao.IFeeClaimPayments;
import gov.va.med.fee.dao.IPaymentLineItemsRepository;
import gov.va.med.fee.dao.IUnmatchedReconciliationRepositoryTemplate;
import gov.va.med.fee.exceptions.GenericException;
import gov.va.med.fee.model.request.UnmatchedClaimPaymentRequest;
import gov.va.med.fee.model.request.UnmatchedReconciliationRequest;
import gov.va.med.fee.model.response.PaymentLineItemsResponse;
import gov.va.med.fee.model.response.UnmatchedClaimPaymentsResponse;
import gov.va.med.fee.model.response.UnmatchedClaimReconciliationResponse;
import gov.va.med.fee.service.IUnmatchedReconciliationService;

/**
 * @author Vamsi Krishna Gangarapu
 *
 */
@Service
public class UnmatchedReconciliationServiceImpl implements IUnmatchedReconciliationService {

	private static final Logger logger = LogManager.getLogger(UnmatchedReconciliationServiceImpl.class);

	private AtomicInteger value = new AtomicInteger(0);

	SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");

	@Autowired
	IClaimRepository iClaimRepository;

	@Autowired
	IClaimPaymentRepository iClaimPaymentRepository;

	@Autowired
	IUnmatchedReconciliationRepositoryTemplate iUnmatchedReconciliationRepositoryTemplate;

	@Autowired
	IPaymentLineItemsRepository iPaymentLineItemsRepository;

	@Autowired
	IFeeClaimPayments iFeeClaimPayments;

	@Autowired
	IFeeClaimPaymentLines iFeeClaimPaymentLines;

	@Autowired
	IAdjustmentGroupRepository iAdjustmentGroupRepository;

	@Autowired
	IAdjustmentReasonRepository iAdjustmentReasonRepository;

	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.fee.service.IUnmatchedClaimsReconciliationService#
	 * getClaimsInformation(java.lang.Long)
	 */

	@Override
	public UnmatchedClaimPaymentsResponse getUnmatchedClaimsInformation(Long claimId) throws GenericException {

		logger.info(" getUnmatchedClaimsInformation() : getting the Unmatched Claim Information");
		UnmatchedClaimPaymentsResponse unmatchedClaimPaymentsResponse = null;
		try {
			logger.debug(
					"UnmatchedReconciliationServiceImpl.getUnmatchedClaimsInformation() invoking the iClaimRepository.findClaimStatusByClaimIndex() for claim index :"
							+ claimId);
			Claim claim = iClaimRepository.findClaimStatusByClaimIndex(claimId);

			if (claim != null) {
				unmatchedClaimPaymentsResponse = new UnmatchedClaimPaymentsResponse();
				unmatchedClaimPaymentsResponse.setClaimId(claim.getClaimIndex());
				unmatchedClaimPaymentsResponse.setClaimType(claim.getServiceType().getServiceTypeCd());
				unmatchedClaimPaymentsResponse.setClaimDate(dateFormat.format(claim.getDateCreated()));
				unmatchedClaimPaymentsResponse.setClaimAmount(claim.getTotalBilledCharge());

			}
			logger.info(
					"UnmatchedReconciliationServiceImpl.getUnmatchedClaimsInformation() invoked the iClaimRepository.findClaimStatusByClaimIndex() returned "
							+ unmatchedClaimPaymentsResponse.toString());

		} catch (Exception e) {
			logger.error("UnmatchedReconciliationServiceImpl.getUnmatchedClaimsInformation() : data_access_error for "
					+ unmatchedClaimPaymentsResponse.toString() + " " + e);
			throw new GenericException(ClaimDetailsConstants.INTERNAL_SERVER_ERROR, e.getMessage(),
					HttpStatus.INTERNAL_SERVER_ERROR);
		}
		return unmatchedClaimPaymentsResponse;
	}

	/**
	 * return unmatchedClaimPaymentsResponseList
	 */
	@Override
	public List<UnmatchedClaimPaymentsResponse> getUnmatchedClaimPayments(
			UnmatchedReconciliationRequest unmatchedReconciliationRequest) throws GenericException {

		List<UnmatchedClaimPaymentsResponse> unmatchedClaimPaymentsResponseList = new ArrayList<UnmatchedClaimPaymentsResponse>();
		try {
			logger.info(" getUnmatchedClaimPayments() : getting the Unmatched Claim Payments");
			logger.debug(
					"UnmatchedReconciliationServiceImpl.getUnmatchedClaimsInformation() invoking the iUnmatchedReconciliationRepositoryTemplate.getClaimPaymentInformation() ");
			unmatchedClaimPaymentsResponseList = iUnmatchedReconciliationRepositoryTemplate
					.getClaimPaymentInformation(unmatchedReconciliationRequest);

			logger.info(
					"UnmatchedReconciliationServiceImpl.getUnmatchedClaimsInformation() invoked the iUnmatchedReconciliationRepositoryTemplate.getClaimPaymentInformation() returned "
							+ unmatchedClaimPaymentsResponseList.toString());

		} catch (Exception e) {
			logger.error("UnmatchedReconciliationServiceImpl.getUnmatchedClaimPayments() : data_access_error for "
					+ unmatchedClaimPaymentsResponseList.toString() + " " + e);
			throw new GenericException(ClaimDetailsConstants.INTERNAL_SERVER_ERROR, e.getMessage(),
					HttpStatus.INTERNAL_SERVER_ERROR);
		}
		return unmatchedClaimPaymentsResponseList;
	}

	/**
	 * return unmatchedClaimReconciliationResponse
	 */
	@Override
	public UnmatchedClaimReconciliationResponse getPaymentLineItems(String feeClaimPaymentId) throws GenericException {

		UnmatchedClaimReconciliationResponse unmatchedClaimReconciliationResponse = null;
		logger.info(" getPaymentLineItems() : getting the Payment Line Items");
		Set<PaymentLineItemsResponse> paymentLineItemsResponseList = new HashSet<PaymentLineItemsResponse>();

		PaymentLineItemsResponse paymentLineItemsResponse = null;

		try {
			logger.debug(
					"iPaymentLineItemsRepository.getFeeClaimPaymentLines : calling the respository to query the database");
			List<FeeClaimPaymentLines> feeClaimPaymentLines = iPaymentLineItemsRepository
					.getFeeClaimPaymentLines(feeClaimPaymentId);
			for (int i = 0; i < feeClaimPaymentLines.size(); i++) {
				for (int j = 0; j < feeClaimPaymentLines.size(); j++) {

					if (feeClaimPaymentLines.get(j).getLineItemSequence().equalsIgnoreCase("ALL")
							|| (Integer.parseInt(feeClaimPaymentLines.get(j).getLineItemSequence()) == i + 1))

						paymentLineItemsResponse = new PaymentLineItemsResponse(
								feeClaimPaymentLines.get(j).getFeeClaimPaymentLineId(),
								feeClaimPaymentLines.get(j).getLineItemSequence(), String.valueOf(incrementAndGet()),
								feeClaimPaymentLines.get(j).getBilledAmount(),
								feeClaimPaymentLines.get(j).getPaidAmount(), feeClaimPaymentLines.get(j).getUnitsPaid(),
								dateFormat.format(feeClaimPaymentLines.get(j).getServiceDate()));
					paymentLineItemsResponseList.add(paymentLineItemsResponse);
				}
			}
			unmatchedClaimReconciliationResponse = new UnmatchedClaimReconciliationResponse();
			unmatchedClaimReconciliationResponse.setPaymentLineItemsResponse(paymentLineItemsResponseList);
		} catch (Exception e) {
			logger.error("UnmatchedReconciliationServiceImpl.getPaymentLineItems() : data_access_error for "
					+ paymentLineItemsResponseList.toString() + " " + e);
			throw new GenericException(ClaimDetailsConstants.INTERNAL_SERVER_ERROR, e.getMessage(),
					HttpStatus.INTERNAL_SERVER_ERROR);
		}

		value.set(0);
		logger.debug("iPaymentLineItemsRepository.getFeeClaimPaymentLines : returned the response "
				+ unmatchedClaimReconciliationResponse.toString());
		return unmatchedClaimReconciliationResponse;
	}

	/**
	 * return unmatchedClaimReconciliationResponse
	 */
	@Override
	public UnmatchedClaimReconciliationResponse EditPaymentInformation(
			UnmatchedClaimPaymentRequest unmatchedClaimPaymentRequest) throws GenericException {

		UnmatchedClaimReconciliationResponse unmatchedClaimReconciliationResponse = null;
		logger.info(" EditPaymentInformation() : getting the Edit Payment Information");
		Boolean value = false;
		try {
			logger.debug(
					"iFeeClaimPaymentLines.getFeeClaimPaymentLinesByFeeClaimPaymentLineId() : calling the respository to query the database");
			FeeClaimPaymentLines feeClaimPaymentLines = iFeeClaimPaymentLines
					.getFeeClaimPaymentLinesByFeeClaimPaymentLineId(
							unmatchedClaimPaymentRequest.getFeeClaimPaymentLineId());
			logger.debug(
					"iFeeClaimPaymentLines.getFeeClaimPaymentsByFeeClaimPaymentsId() : calling the respository to query the database");
			FeeClaimPayments feeClaimPayments = iFeeClaimPayments.getFeeClaimPaymentsByFeeClaimPaymentsId(
					feeClaimPaymentLines.getFeeClaimPayments().getFeeClaimPaymentId());
			feeClaimPayments.setClaimIndex(unmatchedClaimPaymentRequest.getClaimId());

			if (unmatchedClaimPaymentRequest.getAdjustment1() != null
					&& !"".equals(unmatchedClaimPaymentRequest.getAdjustment1())) {
				feeClaimPaymentLines.setAdjustmentAmount1(unmatchedClaimPaymentRequest.getAdjustment1());
			}
			if (unmatchedClaimPaymentRequest.getAdjustment2() != null
					&& !"".equals(unmatchedClaimPaymentRequest.getAdjustment2())) {
				feeClaimPaymentLines.setAdjustmentAmount2(unmatchedClaimPaymentRequest.getAdjustment2());
			}

			if (unmatchedClaimPaymentRequest.getLineNumber() != null
					&& !"".equals(unmatchedClaimPaymentRequest.getLineNumber())) {
				feeClaimPaymentLines.setLineItemSequence(unmatchedClaimPaymentRequest.getLineNumber());

			}

			if (unmatchedClaimPaymentRequest.getGroup1() != null
					&& !"".equals(unmatchedClaimPaymentRequest.getGroup1())) {
				feeClaimPaymentLines.setAdjustmentGroupCode1(unmatchedClaimPaymentRequest.getGroup1());
			}

			if (unmatchedClaimPaymentRequest.getGroup2() != null
					&& !"".equals(unmatchedClaimPaymentRequest.getGroup2())) {
				feeClaimPaymentLines.setAdjustmentGroupCode2(unmatchedClaimPaymentRequest.getGroup2());
			}
			if (unmatchedClaimPaymentRequest.getReason1() != null
					&& !"".equals(unmatchedClaimPaymentRequest.getReason1())) {
				feeClaimPaymentLines.setAdjustmentReasonCode1(unmatchedClaimPaymentRequest.getReason1());
			}
			if (unmatchedClaimPaymentRequest.getReason2() != null
					&& !"".equals(unmatchedClaimPaymentRequest.getReason2())) {
				feeClaimPaymentLines.setAdjustmentReasonCode2(unmatchedClaimPaymentRequest.getReason2());
			}
			java.util.Date today = new java.util.Date();
			java.sql.Date sqlDate = new java.sql.Date(today.getTime());
			feeClaimPaymentLines.setDateModified(sqlDate);
			logger.info(" iFeeClaimPaymentLines.saveAndFlush() : saving the Fee Claim Payment Line Information");
			iFeeClaimPaymentLines.saveAndFlush(feeClaimPaymentLines);
			logger.info(" iFeeClaimPayments.saveAndFlush() : saving the Fee Claim Payments");
			iFeeClaimPayments.saveAndFlush(feeClaimPayments);
			value = true;
			if (value) {
				unmatchedClaimReconciliationResponse = new UnmatchedClaimReconciliationResponse();
				unmatchedClaimReconciliationResponse.setResponse("Claim Reconciled successfully ");
			}

		} catch (Exception e) {
			logger.error(
					"iFeeClaimPaymentLines.getFeeClaimPaymentLinesByFeeClaimPaymentLineId() : data_access_error for "
							+ unmatchedClaimReconciliationResponse.toString() + " " + e);
			throw new GenericException(ClaimDetailsConstants.INTERNAL_SERVER_ERROR, e.getMessage(),
					HttpStatus.INTERNAL_SERVER_ERROR);
		}
		return unmatchedClaimReconciliationResponse;
	}

	public synchronized int incrementAndGet() {
		int result = value.incrementAndGet();
		// in case of integer overflow
		if (result <= 0) {
			value.set(1);
			return 1;
		}
		return result;
	}

	@Override
	public UnmatchedClaimPaymentRequest getEditPaymentInformation(String feeClaimPaymentLineId)
			throws GenericException {
		UnmatchedClaimPaymentRequest unmatchedClaimPaymentRequest = null;
		try {
			logger.debug(
					"iFeeClaimPaymentLines.getEditPaymentInformation() : calling the respository to query the database");
			FeeClaimPaymentLines feeClaimPaymentLines = iFeeClaimPaymentLines.findOne(feeClaimPaymentLineId);
			unmatchedClaimPaymentRequest = new UnmatchedClaimPaymentRequest();
			if (feeClaimPaymentLines.getAdjustmentGroupCode1() != null) {
				logger.debug(
						"iAdjustmentGroupRepository.findAdjustmentGroup() : calling the respository to query the database");
				AdjustmentGroup groupName1 = iAdjustmentGroupRepository
						.findAdjustmentGroup(feeClaimPaymentLines.getAdjustmentGroupCode1());
				if (groupName1 != null) {
					unmatchedClaimPaymentRequest
							.setGroup1(groupName1.getAdjustmentGroupCd() + " - " + groupName1.getDescription());
				}
			}
			if (feeClaimPaymentLines.getAdjustmentReasonCode1() != null) {
				logger.debug(
						"iAdjustmentGroupRepository.findAdjustmentReason() : calling the respository to query the database");
				AdjustmentReason reasonName1 = iAdjustmentReasonRepository
						.findAdjustmentReason(feeClaimPaymentLines.getAdjustmentReasonCode1());
				if (reasonName1 != null) {
					unmatchedClaimPaymentRequest
							.setReason1(reasonName1.getAdjustmentReasonCd() + " - " + reasonName1.getDescription());
				}
			}
			if (feeClaimPaymentLines.getAdjustmentGroupCode2() != null) {
				logger.debug(
						"iAdjustmentGroupRepository.findAdjustmentGroup() : calling the respository to query the database");
				AdjustmentGroup groupName2 = iAdjustmentGroupRepository
						.findAdjustmentGroup(feeClaimPaymentLines.getAdjustmentGroupCode2());
				if (groupName2 != null) {
					unmatchedClaimPaymentRequest
							.setGroup2(groupName2.getAdjustmentGroupCd() + " - " + groupName2.getDescription());
				}
			}
			if (feeClaimPaymentLines.getAdjustmentReasonCode2() != null) {
				logger.debug(
						"iAdjustmentGroupRepository.findAdjustmentReason() : calling the respository to query the database");
				AdjustmentReason reasonName2 = iAdjustmentReasonRepository
						.findAdjustmentReason(feeClaimPaymentLines.getAdjustmentReasonCode2());
				if (reasonName2 != null) {
					unmatchedClaimPaymentRequest
							.setReason2(reasonName2.getAdjustmentReasonCd() + " - " + reasonName2.getDescription());
				}

			}
			unmatchedClaimPaymentRequest.setLineNumber(feeClaimPaymentLines.getLineItemSequence());
			unmatchedClaimPaymentRequest.setFeeClaimPaymentLineId(feeClaimPaymentLines.getFeeClaimPaymentLineId());
			unmatchedClaimPaymentRequest.setAdjustment1(feeClaimPaymentLines.getAdjustmentAmount1());
			unmatchedClaimPaymentRequest.setAdjustment2(feeClaimPaymentLines.getAdjustmentAmount2());

		} catch (Exception e) {
			logger.error("iFeeClaimPaymentLines.getEditPaymentInformation() : data_access_error for "
					+ unmatchedClaimPaymentRequest.toString() + " " + e);
			throw new GenericException(ClaimDetailsConstants.INTERNAL_SERVER_ERROR, e.getMessage(),
					HttpStatus.INTERNAL_SERVER_ERROR);
		}

		return unmatchedClaimPaymentRequest;
	}
}
