package gov.va.med.fee.service.impl;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import gov.va.med.domain.fee.RemittanceRemark;
import gov.va.med.fee.dao.IAdjustmentsRepository;
import gov.va.med.fee.dao.IRemittanceRemarkRepository;
import gov.va.med.fee.exceptions.GenericException;
import gov.va.med.fee.model.response.RemittanceRemarkDTO;
import gov.va.med.fee.model.response.RemittanceRemarkResponse;
import gov.va.med.fee.service.IRemittanceRemarksService;

@Service
public class RemittanceRemarksServiceImpl implements IRemittanceRemarksService{

	@Autowired
	IRemittanceRemarkRepository iRemittanceRemarkRepository;
	
	@Autowired
	IAdjustmentsRepository iDisClaimRepository;
	
	@Override
	public RemittanceRemarkResponse getRemittanceRemarksByReasonCode(String reasonCode) throws GenericException{
		
		List<RemittanceRemark> remittanceRemarkList = iDisClaimRepository.findRemittanceRemarksByReasonCode(reasonCode);
		
		RemittanceRemarkResponse remittanceRemarkResponse = convertToRemittanceResponse(remittanceRemarkList);
		
		return remittanceRemarkResponse;
	}
	
	private RemittanceRemarkResponse convertToRemittanceResponse(List<RemittanceRemark> remittanceRemarkList) {
		RemittanceRemarkResponse remittanceRemarkResponse = new RemittanceRemarkResponse();
		
		List<RemittanceRemarkDTO> remittanceRemarkDTOList = new ArrayList<RemittanceRemarkDTO>();
		for(RemittanceRemark remittanceRemark : remittanceRemarkList) {
			RemittanceRemarkDTO remittanceRemarkDTO = new RemittanceRemarkDTO();
			remittanceRemarkDTO.setCode(remittanceRemark.getRemittanceRemarkCd());
			remittanceRemarkDTO.setDescription(remittanceRemark.getDescription());
			/*remittanceRemarkDTO.setFeeUsageFlag(remittanceRemark.getFeeUsageFlag());
			remittanceRemarkDTO.setCreatedBy(remittanceRemark.getCreatedBy());
			remittanceRemarkDTO.setDateCreated(remittanceRemark.getDateCreated());*/
			
			remittanceRemarkDTOList.add(remittanceRemarkDTO);
		}
		remittanceRemarkResponse.setRemittanceRemarks(remittanceRemarkDTOList);
		
		return remittanceRemarkResponse;
	}
}
