/**
 * 
 */
package gov.va.med.fee.service.impl;

import java.util.ArrayList;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import gov.va.med.domain.fee.Claim;
import gov.va.med.fee.constants.ClaimDetailsConstants;
import gov.va.med.fee.dao.IRejectionHistoryRepositoryTemplate;
import gov.va.med.fee.exceptions.GenericException;
import gov.va.med.fee.model.response.ClaimRejectionHistoryResponse;
import gov.va.med.fee.service.IRejectionHistoryService;

/**
 * @Original author Vinod P
 * version - 1.0
 * 
 * @author Alejandro Barrero
 * version - 1.1
 * 
 * @Modified by Vamsi Krishna Gangarapu
 * version - 2.0
 */

@Service
public class RejectionHistoryServiceImpl implements IRejectionHistoryService {

	private static final Logger logger = LogManager.getLogger(RejectionHistoryServiceImpl.class);

	@Autowired
	IRejectionHistoryRepositoryTemplate iRejectionHistoryRepositoryTemplate;

	/* (non-Javadoc)
	 * @see gov.va.med.fee.service.IRejectionHistoryService#getRejectionHistory(gov.va.med.domain.fee.Claim)
	 */
	@Override
	public List<ClaimRejectionHistoryResponse> getRejectionHistory(Claim claim) throws GenericException {

		List<ClaimRejectionHistoryResponse> rejectionHistoryResults = new ArrayList<ClaimRejectionHistoryResponse>();

		try {
			String claimQueueTypeCode = ClaimDetailsConstants.REJECTION_HISTORY_TAB;
			logger.debug(
					"RejectionHistoryServiceImpl.getRejectionHistory() invoking the RejectionHistoryRepository.findRejectionHistory() for claim index :");
			rejectionHistoryResults = iRejectionHistoryRepositoryTemplate.findRejectionHistory(claimQueueTypeCode, claim.getClaimIndex());

			if ((rejectionHistoryResults.isEmpty())) {
				logger.info(
						"RejectionHistoryServiceImpl.getRejectionHistory() : rejection_history_information_not_found for "
								+ "ClaimIndex: " + claim.getClaimIndex() + " and claimQueueTypeCode = " + claimQueueTypeCode);

				logger.error(
						"RejectionHistoryServiceImpl.getRejectionHistory() : rejection_history_information_not_found for "
								+ "ClaimIndex: " + claim.getClaimIndex() + " and claimQueueTypeCode = " + claimQueueTypeCode);
			} 
		} catch (Exception ex) {
			logger.error("RejectionHistoryServiceImpl.getRejectionHistory() : data_access_error for " + claim.getClaimIndex() + " "
					+ ex);
		}
		return rejectionHistoryResults;
	}

}
