package gov.va.med.fee.service.impl;

import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import gov.va.med.domain.fee.Claim;
import gov.va.med.fee.dao.IReRoutingHistoryRepositoryTemplate;
import gov.va.med.fee.exceptions.GenericException;
import gov.va.med.fee.model.response.ReRoutingHistory;
import gov.va.med.fee.service.IReRoutingHistoryService;

/**
 * 
 * @author Muneshwar Baiah
 *
 */
@Service
@Transactional
public class ReRoutingHistoryServiceImpl implements IReRoutingHistoryService{
	
	public static final Logger logger = LogManager.getLogger(ReRoutingHistoryServiceImpl.class);

	@Autowired
	IReRoutingHistoryRepositoryTemplate reRoutingHistoryRepository;
	
	/* (non-Javadoc)
	 * @see gov.va.med.fee.service.IReRoutingHistoryService#getReRoutingHistoryDetails(gov.va.med.domain.fee.Claim)
	 */
	@Override
	public List<ReRoutingHistory> getReRoutingHistoryDetails(Claim claim) throws GenericException  {
	List<ReRoutingHistory> reRoutingHistoryList = null;
		try {
			logger.debug("ReRoutingHistoryServiceImpl.getReRoutingHistoryDetails() invoking the reRoutingHistoryRepository.findReRoutingHistory():");
			reRoutingHistoryList = reRoutingHistoryRepository.findReRoutingHistory(claim.getClaimIndex());
		} catch (Exception e) {
			logger.error("ReRoutingHistoryServiceImpl.getReRoutingHistoryDetails internal_server_error for "+ e);
		}
		if (reRoutingHistoryList != null && !reRoutingHistoryList.isEmpty()) {
			logger.info(
					"ReRoutingHistoryServiceImpl.getReRoutingHistoryDetails found rerouting history claims");
			logger.debug("ReRoutingHistoryServiceImpl.getReRoutingHistoryDetails rerouting history claims found are :"+reRoutingHistoryList.toString());
		} else {
			logger.info("ReRoutingHistoryServiceImpl.getReRoutingHistoryDetails no rerouting history found");
		}
		return reRoutingHistoryList;	
		}
}
