/**
 * 
 */
package gov.va.med.fee.service.impl;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import gov.va.med.domain.fee.Claim;
import gov.va.med.domain.fee.ProviderInfo;
import gov.va.med.fee.constants.ClaimDetailsConstants;
import gov.va.med.fee.dao.IClaimRepository;
import gov.va.med.fee.dao.IPayToAndServiceProviderRepository;
import gov.va.med.fee.exceptions.GenericException;
import gov.va.med.fee.model.response.ProviderInfoResponse;
import gov.va.med.fee.service.IProviderInfoService;

/**
 * @author Vamsi Krishna Gangarapu
 *
 */
@Service
public class ProviderInfoServiceImpl implements IProviderInfoService {

	private static final Logger logger = LogManager.getLogger(ProviderInfoServiceImpl.class);

	/*
	 * @Autowired ProviderInfoResponse PayToProviderResponse;
	 */

	@Autowired
	IPayToAndServiceProviderRepository iPayToAndServiceProviderRepository;

	@Autowired
	IClaimRepository iClaimRepository;

	/**
	 * 
	 * @param iPayToAndServiceProviderRepository
	 */
	public void setPayToAndServiceProvideRepository(
			IPayToAndServiceProviderRepository iPayToAndServiceProviderRepository) {
		this.iPayToAndServiceProviderRepository = iPayToAndServiceProviderRepository;
	}

	/**
	 * 
	 * @param claimIndex, providerType
	 * @return ProviderInfo
	 * @throws GenericException
	 */
	@Override
	public ProviderInfo getPayToAndServiceInfo(Long claimIndex, String providerType)  {
		ProviderInfo providerInfo = new ProviderInfo();
		try {
			providerInfo = iPayToAndServiceProviderRepository.findOneByType(claimIndex, providerType);
			
		}  catch (Exception ex) {
			logger.error("ProviderInfoServiceImpl.getPayToAndServiceInfo() : internal_server_error for " + claimIndex
					+ " " + ex);
	}
		return providerInfo;
	}

	/**
	 * 
	 * @param Claim
	 * @return ProviderInfoResponse
	 * @throws GenericException
	 */
	@Override
	public ProviderInfoResponse getPayToProviderResponseInfo(Claim claim) throws GenericException {
		ProviderInfoResponse PayToProviderResponse = null;
		//PayToProviderResponse = new ProviderInfoResponse();
		ProviderInfo providerInfo = null;
		try {
			String providerType = ClaimDetailsConstants.PAY_TO_PROVIDER_TYPE;
			providerInfo = getPayToAndServiceInfo(claim.getClaimIndex(), providerType);
		} catch (Exception ex) {
			logger.error("ProviderInfoServiceImpl.getPayToProviderResponseInfo() : data_access_error for " + claim.getClaimIndex()
					+ " " + ex);
		}

		if (providerInfo == null) {
			logger.info("ProviderInfoServiceImpl.getPayToProviderResponseInfo() : claim_not_found for " + claim.getClaimIndex());
			logger.error("ProviderInfoServiceImpl.getPayToProviderResponseInfo() : claim_not_found for " + claim.getClaimIndex());
		} else {
			logger.debug("ProviderInfoServiceImpl.getPayToProviderResponseInfo() claimId :"
					+ providerInfo.getClaim().getClaimIndex() + ", LastName :" + providerInfo.getLastName()
					+ ", AddressLine1 :" + providerInfo.getAddressLine1() + " AddressLine2 :"
					+ providerInfo.getAddressLine2() + ", City :" + providerInfo.getCity() + ", State :"
					+ providerInfo.getState() + " FaxNumber :" + providerInfo.getFaxNumber() + ", PhoneNumber :"
					+ providerInfo.getPhoneNumber() + ", ProviderNpi :" + providerInfo.getProviderNpi()
					+ " ProviderTin :" + providerInfo.getProviderTin());
			logger.debug(
					"ProviderInfoServiceImpl.getPayToProviderResponseInfo() constructing the PayToProvider details response");
			PayToProviderResponse = new ProviderInfoResponse();
			// Constructing the PayToProvider details response
			PayToProviderResponse.setLastName(providerInfo.getLastName());
			PayToProviderResponse.setAddressLine1(providerInfo.getAddressLine1());
			PayToProviderResponse.setAddressLine2(providerInfo.getAddressLine2());
			PayToProviderResponse.setCity(providerInfo.getCity());
			PayToProviderResponse.setState(providerInfo.getState());
			PayToProviderResponse.setFaxNumber(providerInfo.getFaxNumber());
			PayToProviderResponse.setPhoneNumber(providerInfo.getPhoneNumber());
			PayToProviderResponse.setProviderNpi(providerInfo.getProviderNpi());
			PayToProviderResponse.setTaxId(providerInfo.getProviderTin());
			PayToProviderResponse.setEmail(providerInfo.getEMail());
			PayToProviderResponse.setContactName(providerInfo.getContactName());
			PayToProviderResponse.setZipCode(providerInfo.getZipCode());
			logger.debug(
					"ProviderInfoServiceImpl.getPayToProviderResponseInfo() returning the PayToProviderDetailsResponse :"
							+ PayToProviderResponse);
		}
		return PayToProviderResponse;
	}

	/**
	 * 
	 * @param Claim
	 * @return ProviderInfoResponse
	 * @throws GenericException
	 */
	@Override
	public ProviderInfoResponse getServiceProviderResponseInfo(Claim claim) throws GenericException {
		ProviderInfoResponse ServiceProviderResponse = null;
		String providerType = "";
		ProviderInfo providerInfo = null;
		try {
			logger.debug(
					"ClaimDetailsServiceImpl.getClaimDetailsByClaimIndex() invoking the claimRepository.findByClaimIndex() for claim index :"
							+ claim.getClaimIndex());
			//Claim claim = iClaimRepository.findByClaimIndex(claimIndex);
			/*if ((claim == null) || (claim.getClaimIndex() != claimIndex)) {
				return ServiceProviderResponse;
			} else {*/
				if (ClaimDetailsConstants.DENTAL_CLAIM.equalsIgnoreCase(claim.getServiceType().getServiceTypeCd())) {
					providerType = ClaimDetailsConstants.SERVICE_PROVIDER_TYPE_W_DENT;
				} else {
					providerType = ClaimDetailsConstants.SERVICE_PROVIDER_TYPE;
				}
				providerInfo = getPayToAndServiceInfo(claim.getClaimIndex(), providerType);
			//}

		} catch (Exception ex) {
			logger.error("ProviderInfoServiceImpl.getServiceProviderResponseInfo() : data_access_error for "
					+ claim.getClaimIndex() + " " + ex);
	}

		if (providerInfo == null) {
			logger.info("ProviderInfoServiceImpl.getServiceProviderResponseInfo() : claim_not_found for " + claim.getClaimIndex());
			logger.error(
					"ProviderInfoServiceImpl.getServiceProviderResponseInfo() : claim_not_found for " + claim.getClaimIndex());
		
		} else {
			logger.debug("ProviderInfoServiceImpl.getServiceProviderResponseInfo() claimId :"
					+ providerInfo.getClaim().getClaimIndex() + ", LastName :" + providerInfo.getLastName()
					+ ", AddressLine1 :" + providerInfo.getAddressLine1() + " AddressLine2 :"
					+ providerInfo.getAddressLine2() + ", City :" + providerInfo.getCity() + ", State :"
					+ providerInfo.getState() + " FaxNumber :" + providerInfo.getFaxNumber() + ", PhoneNumber :"
					+ providerInfo.getPhoneNumber() + ", ProviderNpi :" + providerInfo.getProviderNpi()
					+ " ProviderTin :" + providerInfo.getProviderTin() + ", ZipCode :" + providerInfo.getZipCode()
					+ " ContactName :" + providerInfo.getContactName());
			logger.debug(
					"ProviderInfoServiceImpl.getServiceProviderResponseInfo() constructing the ServiceProvider details response");
			// Constructing the ServiceProvider details response
			ServiceProviderResponse = new ProviderInfoResponse();
			ServiceProviderResponse.setLastName(providerInfo.getLastName());
			ServiceProviderResponse.setAddressLine1(providerInfo.getAddressLine1());
			ServiceProviderResponse.setAddressLine2(providerInfo.getAddressLine2());
			ServiceProviderResponse.setCity(providerInfo.getCity());
			ServiceProviderResponse.setState(providerInfo.getState());
			ServiceProviderResponse.setEmail(providerInfo.getEMail());
			ServiceProviderResponse.setFaxNumber(providerInfo.getFaxNumber());
			ServiceProviderResponse.setPhoneNumber(providerInfo.getPhoneNumber());
			ServiceProviderResponse.setProviderNpi(providerInfo.getProviderNpi());
			ServiceProviderResponse.setTaxId(providerInfo.getProviderTin());
			ServiceProviderResponse.setZipCode(providerInfo.getZipCode());
			ServiceProviderResponse.setContactName(providerInfo.getContactName());
			logger.debug(
					"ProviderInfoServiceImpl.getServiceProviderResponseInfo() returning the ServiceDetailsResponse :"
							+ ServiceProviderResponse);
		}
		return ServiceProviderResponse;
	}
}
