package gov.va.med.fee.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import gov.va.med.domain.fee.PrivacyToPerson;
import gov.va.med.fee.dao.IPrivacyRestrictionRepo;
import gov.va.med.fee.dao.IPrivacyRestrictionRepositoryTemplate;
import gov.va.med.fee.exceptions.GenericException;
import gov.va.med.fee.model.request.PrivacyRestrictionRequest;
import gov.va.med.fee.service.IPrivacyRestrictionService;


/**
 * 
 * @author DNS   YIBRIK
 * email :yibriekedir@gmail.com
 */

@Service
@Transactional
public class PrivacyRestrictionServiceImpl implements IPrivacyRestrictionService {

	@Autowired
	private IPrivacyRestrictionRepositoryTemplate privecyRestrictionRepoTemplate;
	
	@Autowired
	private IPrivacyRestrictionRepo privacyRestrictionRepo;
	
	
	private static final Logger logger = LogManager.getLogger(PrivacyRestrictionServiceImpl.class);

	
	
	/**
	 * accept a requestId and returns boolean if a privacy
	 * Restriction is removed from DB
	 */
	
	@Override
	public boolean deleteRestriction(long requestId) throws GenericException {

		boolean result =false;
		logger.info("Excuting Method privecyRestrictionRepo.deleteRestriction() To delete request with requestId "+requestId);
		
		try {
			logger.info("Excuting Method privecyRestrictionRepo.deleteRestriction() with requestID "+requestId);			 
			privacyRestrictionRepo.delete(requestId);
			result =true;
			} 
			catch (Exception ex) {
				logger.error("privecyRestrictionRepo.deleteRestriction()  got Exception in performing the request " + requestId
						+ " " + ex);
			}

		return result;
	}
	/**
	 * get all Privacy Restrictions
	 */

	@Override
	public List<PrivacyToPerson> getAllRestrictions() throws GenericException {

		List<PrivacyToPerson> result = new ArrayList<>();
		logger.info("Excuting Method privecyRestrictionRepo.getAllRestrictions() To get all restrictions");

		try {
			logger.info("Excuting Method privecyRestrictionRepo.getAllRestrictions()");
			result = privecyRestrictionRepoTemplate.getAllRestrictions();
			

		} catch (Exception ex) {
			logger.error("privecyRestrictionRepo.deleteRestriction()  got Exception for getting all Restrictions " + " "
					+ ex);
		}

		return result;
	}

	/**
	 * add a new Privacy Restriction to a person
	 */
	
	@Override
	public boolean addPrivacyRestriction(PrivacyRestrictionRequest request) {


       boolean result =false;
		
		try {
		logger.info("Excuting Method privecyRestrictionRepoTemplate.addRestriction() To save request "+request.toString());
	
		 privacyRestrictionRepo.addPrivacyRestriction(request.getNtName(), request.getSsn(), request.getReason(), request.getType(),request.getAppuser().getUserName());
		 result = true;
		} 
		catch (Exception ex) {
			logger.error("privecyRestrictionRepoTemplate.addRestriction()  internal_server_error for request " + request.toString()
					+ " " + ex);
		}
		
		logger.info("privecyRestrictionRepoTemplate.addRestriction() excuted and returning back to the controller");
		return result;
		
	}

	@Override
	public String checkClaim(String ntName, String ssn) {
		
		
		
		List<Integer> listOfClaims = privacyRestrictionRepo.checkClaimAssociatedWithTheUser(ntName, ssn);

		Iterator<?> it = listOfClaims.iterator();
		logger.info("privecyRestrictionRepo.checkClaimsAssignedToUser() checking if User with Person_Id :" + ssn
				+ " and NtName:" + ntName + " has Claims assigned");

		StringBuilder res = new StringBuilder();
		while (it.hasNext()) {
			BigDecimal claim = (BigDecimal) it.next();
			res.append(claim).append(", ");
		}

		if (!res.toString().equalsIgnoreCase("")) {
			logger.info("privecyRestrictionRepo.checkClaimsAssignedToUser() -- > User has claims :" + res.toString()
					+ " Associated with him");
		}
		return res.toString();
	
	}

	@Override
	public boolean checkExist(String ntName, String ssn) {
		  logger.info("PrivecyRestrictionServiceImpl.addRestriction() getting the Privecyrestriction person_Id:"+ssn+"and ntName:"+ntName);			
		  int recordCount = privacyRestrictionRepo.checkPrivacyRestrictionExistanceInDB(ntName, ssn);
			logger.info("privecyRestrictionRepo.checkForExistance() checking if PrivacyRestriction for Person_Id :"+ssn+" and ntName:"+ntName+" Alredady exist");
			
		 if (recordCount > 0) {
			 

           return true;
       }else {
    	   logger.error("PrivacyRestriction for User {person+Id:"+ssn+ "and ntName :"+ntName+"Info already Exist in DB");
    	   return false;
       }
	}
	
	
}
