package gov.va.med.fee.service.impl;

import java.io.ByteArrayOutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.sql.DataSource;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

import gov.va.med.fee.constants.ClaimDetailsConstants;
import gov.va.med.fee.dao.IPrintedClaimRepository;
import gov.va.med.fee.exceptions.GenericException;
import gov.va.med.fee.report.jasper.ReportGenerator;
import gov.va.med.fee.service.IFeeReportService;
import gov.va.med.fee.service.IPrintClaimsService;


@Service
public class PrintClaimsServiceImpl implements IPrintClaimsService {
	private static final Logger logger = LogManager.getLogger(PrintClaimsServiceImpl.class);

	@Autowired
	DataSource dataSource;

	@Autowired
	IPrintedClaimRepository printedClaimRepository;
	
	/**
	 * Generates the PDF claim forms.
	 * 
	 * @param selectedList
	 *            the list of claims to be printed
	 * @return the status code
	 */
	public ByteArrayOutputStream displayClaims(List<Long> selectedList, String appUserName) throws GenericException {
		ByteArrayOutputStream outputStream = null;
		try {
			Connection connection = dataSource.getConnection();

			String claims = selectedList.toString();
			claims = claims.replace("[", "");
			claims = claims.replace("]", "");
			
			Map<String, Object> params = new HashMap<>();
			params.put("Claim_Indices", claims);

			ReportGenerator gen = new ReportGenerator();
			
			/* if (gen.printReport(params, new
			 * StringBuilder(FeeReportService.REPORT_PATH)
			 * .append("Claims").append(FeeReportService.TEMPLATE_EXTENSION).
			 * toString(), "Claims", c)) {
			 */
			outputStream = gen.printReport(params, new StringBuilder(IFeeReportService.REPORT_PATH).append("Claims")
					.append(IFeeReportService.TEMPLATE_EXTENSION).toString(), "Claims", connection);
			
			/*Inserts an entry into the printed claim table to indicate that claim have been printed.*/			
			//createPrintedClaimEntry(selectedList, connection);
			printedClaimRepository.createPrintedClaimEntry(selectedList, appUserName);
		} catch (SQLException e) {
			logger.error("displayClaims error - ");
			e.printStackTrace();
		}
		
		if(outputStream == null || outputStream.size() == 0) {
			throw new GenericException(ClaimDetailsConstants.DATABASE_CONNECTION_FAILURE, "Claim report error",
					HttpStatus.INTERNAL_SERVER_ERROR);
		}
		return outputStream;
	}

	/**
	 * Inserts an entry into the printed claim table to indicate that claim have
	 * been printed. Regular JDBC calls are being used as Hibernate requires the
	 * full Claim object to be retrieved.
	 *
	 * @param list
	 *            list of claim index
	 */
	/*private void createPrintedClaimEntry(List<String> list) {
		EntityManager em = (EntityManager) Component.getInstance("FPPSEntityManager");
		AppUser appUser = (AppUser) Component.getInstance("appUser");

		Connection c = null;
		Object del = em.getDelegate();

		if (del instanceof org.jboss.seam.persistence.HibernateSessionProxy) {
			c = ((org.jboss.seam.persistence.HibernateSessionProxy) del).connection();
		}

		String sql = new String(
				"insert into" + " printed_claim(printed_claim_id, claim_index, created_by, date_created)"
						+ " values(fpps_owner.mig.nextVal, ?, ?, sysdate)");

		String index = null;
		try {
			Iterator<String> iter = list.iterator();
			while (iter.hasNext()) {
				index = iter.next();
				PreparedStatement stmt = c.prepareStatement(sql);
				stmt.setLong(1, Long.parseLong(index));
				stmt.setString(2, appUser.getUserName());

				stmt.executeUpdate();
				stmt.close();
			}
		} catch (SQLException e) {
			logger.error("Error: " + e.getMessage() + " - Could not insert printed claim index: " + index);
		
		} finally {
			try {
				c.close();
			} catch (SQLException e) {
				logger.error(e);
			}
		}
	}*/
}
