package gov.va.med.fee.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.springframework.stereotype.Service;

import gov.va.med.domain.fee.Claim;
import gov.va.med.domain.fee.ClaimOhi;
import gov.va.med.domain.fee.ClaimOhiAdjust;
import gov.va.med.fee.exceptions.GenericException;
import gov.va.med.fee.model.response.OhiInfoResponse;
import gov.va.med.fee.service.IOhiService;

@Service
public class OhiServiceImpl implements IOhiService {

	@Override
	public List<OhiInfoResponse> getOhiInfo(Claim claim) throws GenericException {

		List<OhiInfoResponse> ohiResponse = new ArrayList<OhiInfoResponse>();

		Set<ClaimOhi> claimOhis = new HashSet<ClaimOhi>();
		claimOhis = claim.getClaimOhis();

		for (ClaimOhi claimOhi : claimOhis) {
			OhiInfoResponse response = new OhiInfoResponse();

			response.setOhiPayerId(claimOhi.getOhiPayerId());
			response.setPayerName(claimOhi.getOtherPayerName());
			if(claimOhi.getPaymentSequenceIndicator() != null) {
				response.setPaymentSeqInd(claimOhi.getPaymentSequenceIndicator().toUpperCase());
			}
			response.setGroupName(claimOhi.getOhiGroupName());
			response.setFilingIndicator(claimOhi.getFilingIndicator());
			response.setInsuranceType(claimOhi.getInsuranceType());
			response.setClaimAdjDate(claimOhi.getClaimAdjustmentDate());
			response.setOtherSubInfo(claimOhi.getOtherSubscriberInfo());
			response.setIdCode(claimOhi.getSubscriberIdCode());
			response.setSecondaryId(claimOhi.getSecondarysubscriberIdCode());
			response.setRemittDate(claimOhi.getClaimAdjustmentDate());
			response.setPayerPriorAuthNum(claimOhi.getPayerPriorAuthNum());
			response.setPayerPriorRefNum(claimOhi.getPayerPriorReferralNum());
			
			List<String> rarcCodes = new ArrayList<String>();
			if (claimOhi.getInpRemittanceRemarkCode1() != null) {
				rarcCodes.add(claimOhi.getInpRemittanceRemarkCode1());
			}
			if (claimOhi.getInpRemittanceRemarkCode2() != null) {
				rarcCodes.add(claimOhi.getInpRemittanceRemarkCode2());
			}
			if (claimOhi.getInpRemittanceRemarkCode3() != null) {
				rarcCodes.add(claimOhi.getInpRemittanceRemarkCode3());
			}
			if (claimOhi.getInpRemittanceRemarkCode4() != null) {
				rarcCodes.add(claimOhi.getInpRemittanceRemarkCode4());
			}
			if (claimOhi.getInpRemittanceRemarkCode5() != null) {
				rarcCodes.add(claimOhi.getInpRemittanceRemarkCode5());
			}

			if (claimOhi.getOptRemittanceRemarkCode1() != null) {
				rarcCodes.add(claimOhi.getOptRemittanceRemarkCode1());
			}
			if (claimOhi.getOptRemittanceRemarkCode2() != null) {
				rarcCodes.add(claimOhi.getOptRemittanceRemarkCode2());
			}
			if (claimOhi.getOptRemittanceRemarkCode3() != null) {
				rarcCodes.add(claimOhi.getOptRemittanceRemarkCode3());
			}
			if (claimOhi.getOptRemittanceRemarkCode4() != null) {
				rarcCodes.add(claimOhi.getOptRemittanceRemarkCode4());
			}
			if (claimOhi.getOptRemittanceRemarkCode5() != null) {
				rarcCodes.add(claimOhi.getOptRemittanceRemarkCode5());
			}

			response.setRarcCodes(rarcCodes);

			response.setOhiPaidAmt(claimOhi.getCobPayerPaidAmt());
			response.setTotalNonCovered(claimOhi.getCobTotalNoncoveredAmt());

			List<String> quantity = new ArrayList<String>();
			List<String> adjCodes = new ArrayList<String>();
			List<BigDecimal> adjAmt = new ArrayList<BigDecimal>();

			Set<ClaimOhiAdjust> claimOhiAdjusts = new HashSet<ClaimOhiAdjust>();
			claimOhiAdjusts = claimOhi.getClaimOhiAdjusts();
			for (ClaimOhiAdjust claimAdj : claimOhiAdjusts) {
				if (claimAdj.getQuantity() != null) {
					quantity.add(claimAdj.getQuantity());
				}
				if (claimAdj.getAdjustmentGroup().getAdjustmentGroupCd() != null
						&& claimAdj.getAdjustmentReason().getAdjustmentReasonCd() != null) {
					adjCodes.add(claimAdj.getAdjustmentGroup().getAdjustmentGroupCd().trim()
							+ claimAdj.getAdjustmentReason().getAdjustmentReasonCd().trim());
				}
				if (claimAdj.getAdjustmentAmount() != null) {
					adjAmt.add(claimAdj.getAdjustmentAmount());
				}
			}
			response.setQuantity(quantity);
			response.setAdjCode(adjCodes);
			response.setAdjAmt(adjAmt);

			ohiResponse.add(response);

			Collections.sort(ohiResponse, new Comparator<OhiInfoResponse>() {
				@Override
				public int compare(OhiInfoResponse o1, OhiInfoResponse o2) {
					return assignValueToSequenceIndicatorString(o1.getPaymentSeqInd())
							- assignValueToSequenceIndicatorString(o2.getPaymentSeqInd());
				}

				private int assignValueToSequenceIndicatorString(String paymentSeqInd) {

					int compareValue = 0;

					switch (paymentSeqInd.trim().toUpperCase()) {
					case "P":
						compareValue = 0;
						break;
					case "S":
						compareValue = 1;
						break;
					case "T":
						compareValue = 2;
						break;
					case "A":
						compareValue = 3;
						break;
					case "B":
						compareValue = 4;
						break;
					case "C":
						compareValue = 5;
						break;
					case "D":
						compareValue = 6;
						break;
					case "E":
						compareValue = 7;
						break;
					case "F":
						compareValue = 8;
						break;
					case "G":
						compareValue = 9;
						break;
					case "H":
						compareValue = 10;
						break;
					case "U":				
						compareValue = 11;
						break;
					default:
						compareValue = 11;
					}
					return compareValue;
				}
			});
		}
		if (ohiResponse.size() > 4) {
			List<OhiInfoResponse> firstFour = ohiResponse.subList(0, 4);
			return firstFour;
		}
		return ohiResponse;
	}
}
