package gov.va.med.fee.service.impl;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import gov.va.med.domain.fee.Claim;
import gov.va.med.fee.dao.ILineItemsRepositoryTemplate;
import gov.va.med.fee.exceptions.GenericException;
import gov.va.med.fee.model.request.LineItemsRequest;
import gov.va.med.fee.model.request.SeqDetailRequest;
import gov.va.med.fee.model.response.LineItemResponse;
import gov.va.med.fee.service.ILineItemsService;

@Service
@Transactional
public class LineItemsServiceImpl implements ILineItemsService {
	private static final Logger logger = LogManager.getLogger(LineItemsServiceImpl.class);

	@Autowired
	ILineItemsRepositoryTemplate iLineItemsRepositoryTemplate;

	@SuppressWarnings("unused")
	@Override
	public List<LineItemResponse> getClaimLineItems(Claim claim) throws GenericException {

		StringBuffer sbAmts = new StringBuffer(), sbCodes = new StringBuffer(), sbCagcCodes = new StringBuffer(),
				sbRarcCodes = new StringBuffer();

		BigDecimal bdBilledAmt = null, bdAdjAmt1 = null, bdAdjAmt2 = null;

		SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy");
		// DecimalFormat df = new DecimalFormat("$#0.00");

		BigDecimal procSeq = null;
		// prevProcSeq = new BigDecimal(-1), backProcSeq = new BigDecimal(0),
		// bdPrevPaidAmt = new BigDecimal(0);
		// BigDecimal bdPrevBilledAmt = new BigDecimal(0), bdFirstBilledAmt =
		// new BigDecimal(0);
		BigDecimal bu = new BigDecimal(0); // prevBu = new BigDecimal(0);

		Timestamp tsPrevPaymentDate = new Timestamp(0), tsPaymentDate = new Timestamp(0);
		Timestamp tsPrevServiceFromDate = new Timestamp(0), tsServiceFromDate = new Timestamp(0);
		Timestamp tsPrevServiceToDate = new Timestamp(0), tsServiceToDate = new Timestamp(0);

		DecimalFormat currencyFormat = new DecimalFormat("$#0.00");
		LineItemResponse prevLIE = null;

		List<String> cacrCodeList = new ArrayList<>();
		List<String> cagcCodeList = new ArrayList<>();
		List<String> rarcCodeList = new ArrayList<>();

		List<LineItemResponse> claimLineItems = new ArrayList<>();

		try {
			logger.debug(
					"LineItemsServiceImpl.getLineItems() invoking the claimRepository.findByClaimIndex() for claim index :");

			int iRecCount = 0;
			List<LineItemsRequest> items = iLineItemsRepositoryTemplate.findLineItemsInfo(claim.getClaimIndex());
			for (LineItemsRequest item : items) {
				prevLIE = new LineItemResponse();
				iRecCount++;

				String sFormattedDate = "";
				String sLineItemCheckNumber = "";
				String sTotalAmtPaid = "";
				String procCode = "";
				String revCode = null;
				String modifier1 = "";
				String modifier2 = "";
				String modifier3 = "";
				String modifier4 = "";
				String prodDesc = "";
				String diagPointer = "";
				String lineStatus = "";
				String toothSurface = "";
				String tsCd2 = "";
				String tsCd3 = "";
				String tsCd4 = "";
				String tsCd5 = "";
				String oralCavity = "";
				String toothCode = "";

				if (item.getClaimProcedureSequence() != null) {
					procSeq = item.getClaimProcedureSequence();

					// Setting claimProcId for Manual Reconcile - Out of system payments
					prevLIE.setClaimProcId(item.getClaimProcId().longValue());
					
					if (iRecCount > 0) {
						cacrCodeList = getCARCDetail(procSeq.longValue(), claim.getClaimIndex()); // both
																									// longs
						String codes = (String) cacrCodeList.get(0).toString();
						String amts = (String) cacrCodeList.get(1).toString();
						sTotalAmtPaid = (String) cacrCodeList.get(2).toString();
						sbCodes.append(codes);
						sbAmts.append(amts);
						// Get Adjustment Group Code based on Claim Index and
						// Procedure Sequence
						cagcCodeList = getCAGCDetail(procSeq.longValue(), claim.getClaimIndex());
						String cagcCodes = (String) cagcCodeList.get(0).toString();
						sbCagcCodes.append(cagcCodes);
						// Get Adjustment Group Code based on Claim Index and
						// Procedure Sequence
						rarcCodeList = getRARCDetail(procSeq.longValue(), claim.getClaimIndex());
						String rarcCodes = rarcCodeList.get(0).toString();
						sbRarcCodes.append(rarcCodes);
					}

					// MEDICAL CODE
					prevLIE.setMedical_code(item.getProcCode());// cp.setProcCode((String)
																// row[1]);
					if (item.getProcCode() != null) {
						procCode = item.getProcCode(); // row[1];
					}

					if ("INST".equals(claim.getServiceType().getServiceTypeCd())) {
						if (item.getRevenueCode() != null) { // row[2] != null)
																// {
							revCode = item.getRevenueCode(); // (String) row[2];
							prevLIE.setRevenue_code(revCode);
						}
					}

					// SERVICE FROM DATE
					if (item.getServiceFromDate() != null) { // row[3] != null)
																// {
						tsServiceFromDate = item.getServiceFromDate(); // (Timestamp)
																		// row[3];
					} else {
						tsServiceFromDate = new Timestamp(-1);
					}

					if (item.getServiceToDate() != null) { // row[4] != null) {
						tsServiceToDate = item.getServiceToDate(); // (Timestamp)
																	// row[4];

					} else {
						tsServiceToDate = new Timestamp(-1);

					}

					// BILLED AMOUNT
					if (item.getBilledAmount() != null) { // row[5] != null) {
						bdBilledAmt = item.getBilledAmount(); // (BigDecimal)
																// row[5];
					}

					// PRODUCT CODE DESCRIPTION
					if (item.getProcCodeDesc() != null) { // row[6] != null) {
						prodDesc = item.getProcCodeDesc(); // (String) row[6];

					}

					// DIAG_POINTER
					if (item.getDiagPointer() != null) { // row[7] != null) {
						diagPointer = item.getDiagPointer(); // (String) row[7];
					}

					// BILLED_UNITS
					if (item.getBilledUnits() != null) { // row[8] != null) {
						bu = item.getBilledUnits(); // (BigDecimal) row[8];
					}

					// MODIFIER 1
					if (item.getModifier1() != null) { // row[9] != null) {
						modifier1 = item.getModifier1(); // (String) row[9];
					}

					// MODIFIER 2
					if (item.getModifier2() != null) { // row[10] != null) {
						modifier2 = item.getModifier2(); // (String) row[10];
					}

					// MODIFIER 3
					if (item.getModifier3() != null) { // row[11] != null) {
						modifier3 = item.getModifier3(); // (String) row[11];
					}

					// MODIFIER 4
					if (item.getModifier4() != null) { // row[12] != null) {
						modifier4 = item.getModifier4(); // (String) row[12];
					}

					// PAYMENT DATE
					if (item.getPaymentDate() != null) { // row[13] != null) {
						tsPaymentDate = item.getPaymentDate(); // (Timestamp)
																// row[13];
						sFormattedDate = formatter.format(tsPaymentDate);
					}

					// CHECK NUMBER
					if (item.getPaymentTrackingnumber() != null) { // row[15] !=
																	// null) {
						sLineItemCheckNumber = item.getPaymentTrackingnumber(); // (String)
																				// row[15];
					}

					// TEETH
					// Tooth Code
					if (item.getToothCode() != null) { // row[16] != null) {
						toothCode = item.getToothCode(); // (String) row[16];
					}

					// Tooth Surface
					if (item.getToothSurface() != null) { // row[17] != null) {
						toothSurface = item.getToothSurface(); // (String)
																// row[17];
					}

					// tsCd2
					if (item.getToothSurfaceCd2() != null) { // row[18] != null)
																// {
						tsCd2 = item.getToothSurfaceCd2(); // (String) row[18];
					}

					// tsCd3
					if (item.getToothSurfaceCd3() != null) { // row[19] != null)
																// {
						tsCd3 = item.getToothSurfaceCd3(); // (String) row[19];

					}

					// tsCd4
					if (item.getToothSurfaceCd4() != null) { // row[20] != null)
																// {
						tsCd4 = item.getToothSurfaceCd4(); // (String) row[20];
					}

					// tsCd5
					if (item.getToothSurfaceCd5() != null) { // row[21] != null)
																// {
						tsCd5 = item.getToothSurfaceCd5(); // (String) row[21];
					}

					// ORAL_CAVITY_CD
					if (item.getOralCavityCd() != null) { // row[22] != null) {
						oralCavity = item.getOralCavityCd(); // (String)
																// row[22];
					}

					// LINE STATUS
					if (item.getLineStatus() != null) { // row[23] != null) {
						lineStatus = item.getLineStatus(); // (String) row[23];
					}

					/*
					 * Line ID = claimProcedureSeq Medical Code = procCode
					 * Revenue Code = revenueCd Service From Date =
					 * serviceFromDate Service To Date = serviceToDate Billed
					 * Amount = billedAmount Line Status = lineStatus Treasury
					 * Payment Date = lineItemTreasuryPaymentDateFormatted Paid
					 * Amount = lineItemPaidAmountFormatted Check/EFT/TRN =
					 * lineItemCheckNumber Adjustment Amount = lineItemAdjAmts
					 * Group Code = lineItemCagcCodes Reason Code =
					 * lineItemCodes Remittance Remark Code = lineItemRarcCodes
					 * 
					 */

					prevLIE.setTreasury_payment_date(sFormattedDate);
					prevLIE.setLine_id(procSeq.longValue());
					prevLIE.setBilled_amount(currencyFormat.format(bdBilledAmt));
					prevLIE.setPaid_amount(sTotalAmtPaid);
					prevLIE.setCheck_eft_trn(sLineItemCheckNumber);
					prevLIE.setMedical_code(procCode);
					prevLIE.setService_from_date(formatter.format(tsServiceFromDate));
					prevLIE.setService_to_date(formatter.format(tsServiceToDate));
					prevLIE.setLine_status(lineStatus);

					// Added these changes as part of Build2Sprint4 for Manual
					// Reconciliation Functionality
					prevLIE.setBilled_units(bu.longValue());
					prevLIE.setDescription(prodDesc);

					if ("PROF".equals(claim.getServiceType().getServiceTypeCd())) {
						// prevLIE.setBilled_units(bu.longValue());
						// prevLIE.setDescription(prodDesc);
						prevLIE.setDiagnosis_pointers(diagPointer);
						prevLIE.setModifier_1(modifier1);
						prevLIE.setModifier_2(modifier2);
						prevLIE.setModifier_3(modifier3);
						prevLIE.setModifier_4(modifier4);

					}

					if ("DENT".equals(claim.getServiceType().getServiceTypeCd())) {
						prevLIE.setTooth_code(toothCode);
						prevLIE.setTooth_surface(toothSurface);
						prevLIE.setTooth_surface_cd_2(tsCd2);
						prevLIE.setTooth_surface_cd_3(tsCd3);
						prevLIE.setTooth_surface_cd_4(tsCd4);
						prevLIE.setTooth_surface_cd_5(tsCd5);
						prevLIE.setOral_cavity_cd(oralCavity);
					}

					/*
					 * cpb.setLineItemTreasuryPaymentDateFormatted(
					 * sFormattedDate);
					 * 
					 * cp.setClaimProcedureSeq(procSeq.longValue());
					 * cp.setBilledAmount(bdBilledAmt);
					 * 
					 * cpb.setLineItemPaidAmountFormatted(sTotalAmtPaid);
					 * 
					 * cpb.setLineItemCheckNumber(sLineItemCheckNumber);
					 * cp.setProcCode(procCode);
					 * cp.setServiceFromDate(tsServiceFromDate);
					 * cp.setServiceToDate(tsServiceToDate);
					 * cp.setBilledUnits(bu.longValue());
					 * cp.setProcCodeDesc(prodDesc);
					 * cp.setDiagPointer(diagPointer);
					 * cp.setModifier1(modifier1); cp.setModifier2(modifier2);
					 * cp.setModifier3(modifier3); cp.setModifier4(modifier4);
					 * cp.setLineStatus(lineStatus); cp.setRevenueCode(rc);
					 * 
					 * ti.setToothCode(toothCode);
					 * ti.setToothSurface(toothSurface);
					 * ti.setToothSurfaceCd2(tsCd2);
					 * ti.setToothSurfaceCd3(tsCd3);
					 * ti.setToothSurfaceCd4(tsCd4);
					 * ti.setToothSurfaceCd5(tsCd5);
					 * cp.setOralCavityCd(oralCavity);
					 */

					try {
						if ((sbCodes.length() > 2) && (sbAmts.length() > 2)) {
							sbCodes = new StringBuffer(sbCodes.deleteCharAt(sbCodes.length() - 2));
							sbAmts = new StringBuffer(sbAmts.deleteCharAt(sbAmts.length() - 2));
							prevLIE.setReason_code(sbCodes.toString().trim());
							prevLIE.setAdjustment_amount(sbAmts.toString().trim());
						}

						if (sbCagcCodes.length() > 2) {
							sbCagcCodes = new StringBuffer(sbCagcCodes.deleteCharAt(sbCagcCodes.length() - 2));
							prevLIE.setGroup_code(sbCagcCodes.toString().trim());
						}

						if ((sbRarcCodes.length() > 2)) {
							sbRarcCodes = new StringBuffer(sbRarcCodes.deleteCharAt(sbRarcCodes.length() - 2));
							prevLIE.setRemittance_remark_code(sbRarcCodes.toString().trim());
						}

					} catch (IndexOutOfBoundsException iob) {
						iob.printStackTrace();
						logger.error(iob.getMessage(), iob);
					} catch (Exception ex) {
						ex.printStackTrace();
						logger.error(ex.getMessage(), ex);
					}

					claimLineItems.add(prevLIE);

					// clean up
					prevLIE = null;
					sbCodes.setLength(0);
					sbAmts.setLength(0);
					sbCagcCodes.setLength(0);
					sbRarcCodes.setLength(0);
				}
			}

		} catch (Exception e) {
			e.printStackTrace();
			logger.error("ViewClaimBean.findClaimByClaimIndex(): error getting line items payment information - "
					+ e.getMessage());
		}

		return claimLineItems;
	}

	public List<String> getCARCDetail(long seq, long claimIndex) {
		final String COMMA = ", ";
		ArrayList<String> list = new ArrayList<>();
		DecimalFormat df = new DecimalFormat("$#0.00");
		String prevAdjReasonCode = "";
		String sTotal = "";
		StringBuffer sbCodes = new StringBuffer();
		String prevAdjAmt = "";
		StringBuffer sbAmts = new StringBuffer();
		Long bdAdjAmt1 = new Long(0);
		Long bdPaidAmt = new Long(0);

		// float bdTotal = 0;
		float fTotalPaidAmt = 0;
		float fTemp = 0;

		try {
			SeqDetailRequest request = iLineItemsRepositoryTemplate.getCARCDetail(seq, claimIndex);
			if (request != null) {

				if (request.getPrevAdjReasonCode() != null) {
					prevAdjReasonCode = request.getPrevAdjReasonCode();
					sbCodes.append(prevAdjReasonCode + COMMA);
				}

				if (request.getBdAdjAmt1() != null) {
					bdAdjAmt1 = request.getBdAdjAmt1();
					prevAdjAmt = df.format(bdAdjAmt1.floatValue());
					sbAmts.append(prevAdjAmt + COMMA);
				}

				if (request.getBdPaidAmt() != null) {
					bdPaidAmt = request.getBdPaidAmt();
					fTemp = bdPaidAmt.floatValue();
					fTotalPaidAmt += fTemp;
					sTotal = df.format(fTotalPaidAmt);
				}
			}

			list.add(sbCodes.toString()); // sbCodes is StringBuffer
			list.add(sbAmts.toString());
			list.add(sTotal);

		} catch (Exception e) {
			logger.error("LineItemsServiceImpl.getSequenceDetails(): ERROR: " + e.getMessage());
		}
		return list;

	}

	public List<String> getCAGCDetail(long seq, long claimIndex) {
		final String COMMA = ", ";
		List<String> list = new ArrayList<>();
		String prevAdjGroupCode = "";
		StringBuffer sbCodes = new StringBuffer();

		List<SeqDetailRequest> request = iLineItemsRepositoryTemplate.getCAGCDetail(seq, claimIndex);
		for (SeqDetailRequest req : request) {
			if (req.getAdjustmentGroupCd() != null) {
				prevAdjGroupCode = req.getAdjustmentGroupCd();
				sbCodes.append(prevAdjGroupCode + COMMA);
			}
		}

		list.add(sbCodes.toString());
		return list;
	}

	public List<String> getRARCDetail(long seq, long claimIndex) {

		final String COMMA = ", ";
		List<String> list = new ArrayList<>();
		String prevAdjRemarkCode = "";
		StringBuffer sbCodes = new StringBuffer();

		List<SeqDetailRequest> request = iLineItemsRepositoryTemplate.getRARCDetail(seq, claimIndex);

		for (SeqDetailRequest req : request) {
			if (req.getRemittanceRemarkCd() != null) {
				prevAdjRemarkCode = req.getRemittanceRemarkCd();
				sbCodes.append(prevAdjRemarkCode + COMMA);
			}
		}
		
		list.add(sbCodes.toString());

		return list;
	} // end getRARCDetail
	
}
