package gov.va.med.fee.service.impl;

import java.io.ByteArrayOutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

import javax.sql.DataSource;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import gov.va.med.fee.model.request.SearchCriteriaRequest;
import gov.va.med.fee.report.jasper.ReportGenerator;
import gov.va.med.fee.report.jasper.ReportPrepFactory;
import gov.va.med.fee.report.jasper.ReportPreparer;
import gov.va.med.fee.service.IFeeReportService;

@Service
public class FeeReportServiceImpl implements IFeeReportService {
	private static final Logger logger = LogManager.getLogger(FeeReportServiceImpl.class);

	@Autowired
	DataSource dataSource;

	private SearchCriteriaRequest criteria = new SearchCriteriaRequest();

	/** The show print popup. */
	private boolean showPrintPopup = false;

	public void submitJasper() {
		if (criteria.isValid()) {
			showPrintPopup = true;
		}
	}

	public Map<String, Object> displayJasper() {
		ByteArrayOutputStream outputStream = null;
		Map<String, Object> resultMap = new HashMap<>();
		String template = "template";
		
		try {
			Connection c = dataSource.getConnection();

			if (dataSource == null) {
				logger.debug("dataSource is NULL");
			}

			showPrintPopup = false;
			ReportPreparer prep = new ReportPrepFactory().getPreparer(criteria);

			template = prep.getTemplateName();

			System.out.println("template -" + template);
			Map<String, Object> p = prep.getParams();

			ReportGenerator gen = new ReportGenerator();

			/*
			 * if (gen.printReport(criteria.getFormat(), p, new
			 * StringBuffer(REPORT_PATH).append(template).append(
			 * TEMPLATE_EXTENSION).toString(), template, c)) { return NEXT;
			 */

			outputStream = gen.printReport(criteria.getFormat(), p,
					new StringBuffer(REPORT_PATH).append(template).append(TEMPLATE_EXTENSION).toString(), template, c);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		resultMap.put("fileName", template);
		resultMap.put("output", outputStream.toByteArray());
		
		return resultMap;
	}

	public void setCriteria(SearchCriteriaRequest criteria) {
		this.criteria = criteria;
	}

}
