/**
 * 
 */
package gov.va.med.fee.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import gov.va.med.domain.fee.Claim;
import gov.va.med.domain.fee.HealthcareInfoCode;
import gov.va.med.fee.constants.ClaimDetailsConstants;
import gov.va.med.fee.dao.IDiagnosisCodeRepository;
import gov.va.med.fee.enums.DiagCodeSortOrder;
import gov.va.med.fee.exceptions.GenericException;
import gov.va.med.fee.model.response.DiagnosisCodes;
import gov.va.med.fee.service.IDiagnosisCodeService;

/**
 * @author Vamsi Krishna Gangarapu
 *
 */
@Service
public class DiagnosisCodeServiceImpl implements IDiagnosisCodeService {

	private static final Logger logger = LogManager.getLogger(DiagnosisCodeServiceImpl.class);

	@Autowired
	IDiagnosisCodeRepository iDiagnosisCodeRepository;

	/* (non-Javadoc)
	 * @see gov.va.med.fee.service.IDiagnosisCodeService#getDiagnosisCodes(gov.va.med.domain.fee.Claim)
	 */
	@SuppressWarnings("null")
	@Override
	public List<DiagnosisCodes> getDiagnosisCodes(Claim claim) throws GenericException {
		// DiagnosisCodeResponse diagnosisCodeResponse = null;
		List<DiagnosisCodes> diagnosisCodeList = new ArrayList<DiagnosisCodes>();
		try {
			logger.debug(
					"DiagnosisCodeServiceImpl.getDiagnosisCodes() invoking the claimRepository.findByClaimIndex() for claim index :");
			// Claim claim = iClaimRepository.findClaimByClaimIndex(claimIndex);
			if ((claim == null)) {
				logger.info(
						"DiagnosisCodeServiceImpl.getDiagnosisCodes() : claim_not_found for " + claim.getClaimIndex());
				logger.error(
						"DiagnosisCodeServiceImpl.getDiagnosisCodes() : claim_not_found for " + claim.getClaimIndex());
				/*
				 * throw new ClaimException("Diagnosis_tab_info_not_found",
				 * "No Diagnosis Tab Info found with claim id " + claimIndex,
				 * HttpStatus.NOT_FOUND);
				 */
			} else {
				if (!(claim.getServiceType().getServiceTypeCd().equalsIgnoreCase(ClaimDetailsConstants.DENTAL_CLAIM))) {
					String poa = (String) claim.getPoaIndicator();
					if (poa == null || poa.equalsIgnoreCase("null")) {
						poa = "";
					}

					poa = poa.startsWith("POA") ? poa.substring(3, poa.length()) : poa;
					poa = poa.indexOf("Z") > 0 ? poa.substring(0, poa.indexOf("Z")) : poa;

					logger.debug(
							"DiagnosisCodeServiceImpl.getDiagnosisCodes() invoking the DiagnosisCodeRepository.findAllByClaim() for claim index :");
					List<HealthcareInfoCode> healthCodes = iDiagnosisCodeRepository
							.findAllByClaim(claim.getClaimIndex());

					if ((healthCodes.size() <= 0)) {
						logger.info(
								"DiagnosisCodeServiceImpl.getDiagnosisCodes() : diagnosis_information_not_found for "
										+ claim.getClaimIndex());
						logger.error(
								"DiagnosisCodeServiceImpl.getDiagnosisCodes() : diagnosis_information_not_found for "
										+ claim.getClaimIndex());
						/*
						 * throw new
						 * ClaimException("Diagnosis_tab_info_not_found",
						 * "No Diagnosis Tab Info found with claim id " +
						 * claimIndex, HttpStatus.NOT_FOUND);
						 */
					} else {
						for (HealthcareInfoCode c : healthCodes) {

							String[] procCd = { c.getHi01procCd(), c.getHi02procCd(), c.getHi03procCd(),
									c.getHi04procCd(), c.getHi04procCd(), c.getHi05procCd(), c.getHi06procCd(),
									c.getHi07procCd(), c.getHi08procCd(), c.getHi09procCd(), c.getHi10procCd(),
									c.getHi11procCd(), c.getHi12procCd() };
							String[] procDesc = { c.getHi01procDesc(), c.getHi02procDesc(), c.getHi03procDesc(),
									c.getHi04procDesc(), c.getHi04procDesc(), c.getHi05procDesc(), c.getHi06procDesc(),
									c.getHi07procDesc(), c.getHi08procDesc(), c.getHi09procDesc(), c.getHi10procDesc(),
									c.getHi11procDesc(), c.getHi12procDesc() };
							String[] cndtnResponseCd = { c.getHi01cndtnResponseCd(), c.getHi02cndtnResponseCd(),
									c.getHi03cndtnResponseCd(), c.getHi04cndtnResponseCd(), c.getHi04cndtnResponseCd(),
									c.getHi05cndtnResponseCd(), c.getHi06cndtnResponseCd(), c.getHi07cndtnResponseCd(),
									c.getHi08cndtnResponseCd(), c.getHi09cndtnResponseCd(), c.getHi10cndtnResponseCd(),
									c.getHi11cndtnResponseCd(), c.getHi12cndtnResponseCd() };
							String[] cdListQual = { c.getHi01cdListQual(), c.getHi02cdListQual(), c.getHi03cdListQual(),
									c.getHi04cdListQual(), c.getHi04cdListQual(), c.getHi05cdListQual(),
									c.getHi06cdListQual(), c.getHi07cdListQual(), c.getHi08cdListQual(),
									c.getHi09cdListQual(), c.getHi10cdListQual(), c.getHi11cdListQual(),
									c.getHi12cdListQual() };

							for (int i = 1; i < ((procCd.length) - 1); i++) {
								diagnosisCodeList.add(addToListMethod(i, procCd[i], poa, procDesc[i], cdListQual[i],
										cndtnResponseCd[i]));
							}
						}

						diagnosisCodeList.removeAll(Collections.singleton(null));
						if (diagnosisCodeList.isEmpty()) {
							return diagnosisCodeList;
						}

						sortDiagCodes(diagnosisCodeList);

					}
				}
			}
		} catch (Exception ex) {
			logger.error("DiagnosisCodeServiceImpl.getDiagnosisCodes() : data_access_error for " + claim.getClaimIndex()
					+ " " + ex);
		}

		recreateSequenceNumberForScreen(diagnosisCodeList);
		return diagnosisCodeList;
	}

	/**
	 * @param seq
	 * @param code
	 * @param poa
	 * @param desc
	 * @param qual
	 * @param poa5010
	 * @return DiagnosisCodes
	 */
	private DiagnosisCodes addToListMethod(int seq, String code, String poa, String desc, String qual, String poa5010) {

		DiagnosisCodes dc = null;

		if (code != null && !code.equals("") && qual != null
				&& (qual.startsWith("BK") || qual.startsWith("BJ") || qual.startsWith("PR") || qual.startsWith("BF")
						|| qual.startsWith("BN") || qual.startsWith("ABK") || qual.startsWith("ABJ")
						|| qual.startsWith("APR") || qual.startsWith("ABF") || qual.startsWith("ABN"))) {
			String p = (poa.length() >= seq) ? (poa.charAt(seq - 1) + "") : "";

			// If the poa string is null or empty but the 5010 poa is populated
			// then set the poa indicator to the one sent in 5010
			if ((poa == null || poa.isEmpty() || poa.trim().isEmpty())
					&& (poa5010 != null && !poa5010.isEmpty() && !poa5010.trim().isEmpty())) {
				p = poa5010;
			}

			dc = new DiagnosisCodes(seq, code, qual, p, desc);
		}

		return dc;

	}

	// This method numbers the sequence number associated with each diagnosis
	// code
	// starting at 1 for the first code in the list ending at length for the
	// last
	/**
	 * @param diagnosisCodesToRenumber
	 */
	private void recreateSequenceNumberForScreen(List<DiagnosisCodes> diagnosisCodesToRenumber) {
		int diagCodeSeqNumber = 1;
		for (DiagnosisCodes entityToRenumber : diagnosisCodesToRenumber) {
			entityToRenumber.setSequenceNumber(diagCodeSeqNumber);
			diagCodeSeqNumber++;
		}
	}

	// Sort the diagnosis codes for proper ordering on the screen
	/**
	 * @param diaCodes
	 */
	private void sortDiagCodes(List<DiagnosisCodes> diaCodes) {
		Collections.sort(diaCodes, new Comparator<DiagnosisCodes>() {

			private DiagCodeSortOrder returnDiagCodeEnum(DiagnosisCodes arg0) {
				if (arg0.getDiagnosisCodeQualifier() == null || arg0.getDiagnosisCodeQualifier().trim() == null) {
					return DiagCodeSortOrder.UNKNOWN;
				}

				String trimmedCode = arg0.getDiagnosisCodeQualifier().trim();
				if (trimmedCode.equalsIgnoreCase("BK"))
					return DiagCodeSortOrder.BK;
				if (trimmedCode.equalsIgnoreCase("BF"))
					return DiagCodeSortOrder.BF;
				if (trimmedCode.equalsIgnoreCase("BJ"))
					return DiagCodeSortOrder.BJ;
				if (trimmedCode.equalsIgnoreCase("PR"))
					return DiagCodeSortOrder.PR;
				if (trimmedCode.equalsIgnoreCase("BN"))
					return DiagCodeSortOrder.BN;
				if (trimmedCode.equalsIgnoreCase("ABK"))
					return DiagCodeSortOrder.BK;
				if (trimmedCode.equalsIgnoreCase("ABF"))
					return DiagCodeSortOrder.BF;
				if (trimmedCode.equalsIgnoreCase("ABJ"))
					return DiagCodeSortOrder.BJ;
				if (trimmedCode.equalsIgnoreCase("APR"))
					return DiagCodeSortOrder.PR;
				if (trimmedCode.equalsIgnoreCase("ABN"))
					return DiagCodeSortOrder.BN;
				return DiagCodeSortOrder.UNKNOWN;
			}

			@Override
			public int compare(DiagnosisCodes arg0, DiagnosisCodes arg1) {
				DiagCodeSortOrder aDiagCode = returnDiagCodeEnum(arg0);
				DiagCodeSortOrder bDiagCode = returnDiagCodeEnum(arg1);
				return aDiagCode.compareTo(bDiagCode);
			}
		});
	}

}
