package gov.va.med.fee.service.impl;

import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

import gov.va.med.fee.constants.ClaimDetailsConstants;
import gov.va.med.fee.dao.impl.DiagnosisCodeLookupRepositoryImpl;
import gov.va.med.fee.dao.impl.MedicalCodeLookupRepositoryImpl;
import gov.va.med.fee.exceptions.GenericException;
import gov.va.med.fee.model.response.CodeLookupResponse;
import gov.va.med.fee.model.response.GenericResponse;
import gov.va.med.fee.service.ICodeLookupService;

/**
 * @author Vamsi Krishna Gangarapu
 * 
 * @author Muneshwar Baiah -- Added the functionality for DiagnosisCodeLookup as part of Build2Sprint3
 *
 */
@Service
public class CodeLookupServiceImpl implements ICodeLookupService {

	public static final Logger logger = LogManager.getLogger(CodeLookupServiceImpl.class);

	@Autowired
	MedicalCodeLookupRepositoryImpl iMedicalCodeRepositoryImpl;

	@Autowired
	DiagnosisCodeLookupRepositoryImpl idiagnosisCodeLookupRepositoryImpl;


	/* (non-Javadoc)
	 * @see gov.va.med.fee.service.ICodeLookupService#getMedicalCodes(java.lang.String, java.lang.String, java.lang.Integer, java.lang.String, java.lang.Integer)
	 */
	@Override
	public GenericResponse getMedicalCodes(String medicalCode, String codeType, Integer pageSize,
			String sortColumn, Boolean descending, Integer pageNumber) throws GenericException {
		GenericResponse medicalCodeResponse = null;
		try {
			logger.info(" getMedicalCodes() : getting the medical code list");
			Long resultsCount = iMedicalCodeRepositoryImpl.getCount(medicalCode, codeType, pageSize, sortColumn,descending, pageNumber);
			logger.debug("getMedicalCodes() : resultsCount is :"+resultsCount);
			
			if( resultsCount <=  (pageSize * pageNumber) ) {
				Integer resultCountIntVal = resultsCount.intValue();
				float pageNumberFloat  =  (float)resultCountIntVal / (float)pageSize;
				pageNumber = (int) Math.ceil(pageNumberFloat);
				//pageSize = resultCountIntVal % pageSize;
			logger.debug("getMedicalCodes() : pageNumber is :"+pageNumber+" and pageSize is :"+pageSize);
			}
			
			if(resultsCount != 0 && resultsCount > 0) {
				logger.debug("iMedicalCodeRepositoryImpl.getCodes() : calling the respository to query the database");
				List<CodeLookupResponse> medicalCodeResponseList = iMedicalCodeRepositoryImpl.getCodes(medicalCode, codeType, pageSize, sortColumn,descending, pageNumber);
				medicalCodeResponse = new GenericResponse(pageNumber, pageSize, sortColumn, resultsCount);
				medicalCodeResponse.setResponse(medicalCodeResponseList);
			} else {
				logger.error("CodeLookupServiceImpl.getMedicalCodes() : invalid_input_error resulted in no rows "
						+ resultsCount);
				throw new GenericException(ClaimDetailsConstants.NO_CONTENT,
						"Invalid input resulted in 0 rows", HttpStatus.NO_CONTENT);
			}
		}
		catch (Exception e) {
			e.printStackTrace();
			logger.error("getMedicalCodes() : Exception occurred : " + e);
			throw new GenericException(ClaimDetailsConstants.INTERNAL_SERVER_ERROR, e.getMessage(),
					HttpStatus.INTERNAL_SERVER_ERROR);
		}
		logger.debug("getMedicalCodes() : response is : "+medicalCodeResponse);
		return medicalCodeResponse;
	}


	/* (non-Javadoc)
	 * @see gov.va.med.fee.service.ICodeLookupService#getDiagnosisCodes(java.lang.String, java.lang.String, java.lang.Integer, java.lang.String, java.lang.Integer)
	 */
	@Override
	public GenericResponse getDiagnosisCodes(String medicalCode, String codeType, Integer pageSize,
			String sortColumn, Boolean descending, Integer pageNumber)  throws GenericException {
		GenericResponse diagnosisCodeResponse = null;
		try {
			logger.info(" getDiagnosisCodes() : getting the medical code list");
			Long resultsCount = idiagnosisCodeLookupRepositoryImpl.getCount(medicalCode, codeType, pageSize, sortColumn, descending, pageNumber);
			logger.debug("getDiagnosisCodes() : resultsCount is :"+resultsCount);
			

			if( resultsCount <=  (pageSize * pageNumber) ) {
				Integer resultCountIntVal = resultsCount.intValue();
				float pageNumberFloat  =  (float)resultCountIntVal / (float)pageSize;
				pageNumber = (int) Math.ceil(pageNumberFloat);
				//pageSize = resultCountIntVal % pageSize;
			logger.debug("getMedicalCodes() : pageNumber is :"+pageNumber+" and pageSize is :"+pageSize);
			}
			
			
			if(resultsCount != 0 && resultsCount > 0) {
				logger.debug("idiagnosisCodeLookupRepositoryImpl.getCodes() : calling the respository to query the database");
				List<CodeLookupResponse> medicalCodeResponseList = idiagnosisCodeLookupRepositoryImpl.getCodes(medicalCode, codeType, pageSize, sortColumn,descending, pageNumber);

				diagnosisCodeResponse = new GenericResponse(pageNumber, pageSize, sortColumn, resultsCount);
				diagnosisCodeResponse.setResponse(medicalCodeResponseList);
			} else {
				logger.error("CodeLookupServiceImpl.getDiagnosisCodes() : invalid_input_error resulted in no rows "
						+ resultsCount);
				throw new GenericException(ClaimDetailsConstants.NO_CONTENT,
						"Invalid input resulted in 0 rows", HttpStatus.NO_CONTENT);
			}
		}
		catch (Exception e) {
			e.printStackTrace();
			logger.error("getDiagnosisCodes() : Exception occured :" + e);
			throw new GenericException(ClaimDetailsConstants.INTERNAL_SERVER_ERROR, e.getMessage(),
					HttpStatus.INTERNAL_SERVER_ERROR);
		}
		logger.debug("getDiagnosisCodes() : response is : "+diagnosisCodeResponse);
		return diagnosisCodeResponse;
	}

}
