/**
 * 
 */
package gov.va.med.fee.service.impl;

import java.util.ArrayList;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

import gov.va.med.fee.constants.ClaimDetailsConstants;
import gov.va.med.fee.dao.IClaimSearchRepositoryTemplate;
import gov.va.med.fee.exceptions.GenericException;
import gov.va.med.fee.model.request.ClaimSearchProcessingRequest;
import gov.va.med.fee.model.response.ClaimSearchResponse;
import gov.va.med.fee.model.response.GenericResponse;
import gov.va.med.fee.service.IClaimSearchService;

/**
 * @author Vamsi Krishna Gangarapu
 *
 */
@Service
public class ClaimSearchServiceImpl implements IClaimSearchService {

	private static final Logger logger = LogManager.getLogger(ClaimSearchServiceImpl.class);

	@Autowired
	IClaimSearchRepositoryTemplate iClaimSearchRepositoryTemplate;

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * gov.va.med.fee.service.IClaimSearchService#getClaimSearchResults(gov.va.
	 * med.fee.model.request.ClaimSearchProcessingRequest)
	 */
	@Override
	public GenericResponse getClaimSearchResults(ClaimSearchProcessingRequest claimSearchProcessingRequest)
			throws GenericException {
		GenericResponse claimSearchResponse = null;
		List<ClaimSearchResponse> claimSearchResponseResults = new ArrayList<ClaimSearchResponse>();
		try {
			int pageNumber = 0;
			logger.info(" getClaimSearchResults() : getting the Claim Search list");
			Long resultsCount = iClaimSearchRepositoryTemplate.getCountResults(claimSearchProcessingRequest);
			logger.debug("getClaimSearchResults() : resultsCount is :" + resultsCount);

			if (resultsCount <= (claimSearchProcessingRequest.getPageSize()
					* claimSearchProcessingRequest.getPageNumber())) {
				Integer resultCountIntVal = resultsCount.intValue();
				float pageNumberFloat = (float) resultCountIntVal / (float) claimSearchProcessingRequest.getPageSize();
				pageNumber = (int) Math.ceil(pageNumberFloat);
				// pageSize = resultCountIntVal % pageSize;
				logger.debug(
						"getClaimSearchResults() : pageNumber is :" + pageNumber + " and pageSize is :" + claimSearchProcessingRequest.getPageSize());
			}

			if (resultsCount != 0 && resultsCount > 0) {
				logger.debug(
						"iClaimSearchRepositoryTemplate.getClaimSearchResultsList() : calling the respository to query the database");
				
				if(pageNumber == 0 ) {
					claimSearchResponseResults = iClaimSearchRepositoryTemplate
							.getClaimSearchResultsList(claimSearchProcessingRequest);
					claimSearchResponse = new GenericResponse(claimSearchProcessingRequest.getPageNumber(),
							claimSearchProcessingRequest.getPageSize(), claimSearchProcessingRequest.getSortColumn(),
							resultsCount);
				} else {
					claimSearchProcessingRequest.setPageNumber(pageNumber);
					claimSearchResponseResults = iClaimSearchRepositoryTemplate
							.getClaimSearchResultsList(claimSearchProcessingRequest);
					claimSearchResponse = new GenericResponse(pageNumber,
							claimSearchProcessingRequest.getPageSize(), claimSearchProcessingRequest.getSortColumn(),
							resultsCount);
				}
				

				claimSearchResponse.setResponse(claimSearchResponseResults);
				if (claimSearchResponseResults.isEmpty()) {
					logger.info("ClaimSearchServiceImpl.getClaimSearchResults() : claim_search_information_not_found "
							+ claimSearchProcessingRequest.toString());

					logger.error(
							"ClaimSearchServiceImpl.getClaimSearchResults() : claim_search_information_not_found for"
									+ claimSearchProcessingRequest.toString());
				}
			}
		} catch (Exception e) {
			logger.error("ClaimSearchServiceImpl.getClaimSearchResults() : data_access_error for "
					+ claimSearchProcessingRequest.toString() + " " + e);
			throw new GenericException(ClaimDetailsConstants.INTERNAL_SERVER_ERROR, e.getMessage(),
					HttpStatus.INTERNAL_SERVER_ERROR);
		}
		logger.debug("getClaimSearchResponse() : response is : " + claimSearchResponse);
		return claimSearchResponse;
	}

	@Override
	public ClaimSearchResponse getOneClaimSearchResults(String claimId) throws GenericException {
		ClaimSearchResponse claimSearchResponse = null;
		try {
			claimSearchResponse = iClaimSearchRepositoryTemplate
					.getOneClaimSearchResult(claimId);
		} catch (Exception e) {
			logger.error("ClaimSearchServiceImpl.getClaimSearchResults() : data_access_error for "
					+ claimSearchResponse.toString() + " " + e);
			throw new GenericException(ClaimDetailsConstants.INTERNAL_SERVER_ERROR, e.getMessage(),
					HttpStatus.INTERNAL_SERVER_ERROR);
		}
		
		return claimSearchResponse;
	}

}
