/**
 * 
 */
package gov.va.med.fee.service.impl;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import gov.va.med.domain.fee.Claim;
import gov.va.med.domain.fee.ProviderInfo;
import gov.va.med.fee.constants.ClaimDetailsConstants;
import gov.va.med.fee.dao.IBillingRepositoryTemplate;
import gov.va.med.fee.exceptions.GenericException;
import gov.va.med.fee.model.response.ProviderInfoResponse;
import gov.va.med.fee.service.IBillingProviderService;

/**
 * @author Vamsi Krishna Gangarapu
 *
 */
@Service
public class BillingProviderServiceImpl implements IBillingProviderService {

	private static final Logger logger = LogManager.getLogger(BillingProviderServiceImpl.class);

	@Autowired
	IBillingRepositoryTemplate iBillingProviderRepository;

	/**
	 * @return the iBillingProviderRepository
	 */
	public IBillingRepositoryTemplate getiBillingProviderRepository() {
		return iBillingProviderRepository;
	}

	/**
	 * @param iBillingProviderRepository the iBillingProviderRepository to set
	 */
	public void setiBillingProviderRepository(IBillingRepositoryTemplate iBillingProviderRepository) {
		this.iBillingProviderRepository = iBillingProviderRepository;
	}

	/**
	 * This method queries the database using the spring data JPA and constructs
	 * the appropriate response.
	 * 
	 * @param Claim
	 * @return ProviderInfoResponse
	 * @throws GenericException
	 */
	@Override
	public ProviderInfoResponse getBillingProviderResponse(Claim claim) {
		logger.info("BillingProviderServiceImpl.getBillingProviderResponse() getting the billing provider details for claim index :"+claim.getClaimIndex());
		ProviderInfoResponse billingProviderResponse = null;
		ProviderInfo billingProviderInformation = new ProviderInfo();
		try {
		logger.info("BillingProviderServiceImpl.getBillingProviderResponse() invoking the iBillingProviderRepository.findOneByProvider()");
			billingProviderInformation = iBillingProviderRepository.findOneByProvider(claim.getClaimIndex(),
					ClaimDetailsConstants.BILLING_PROVIDER_TYPE, ClaimDetailsConstants.BILLING_PROVIDER_TYPE_OLD);
		} 
		catch (Exception ex) {
			logger.error("BillingProviderServiceImpl.getBillingProviderResponse() internal_server_error for " + claim.getClaimIndex()
					+ " " + ex);
		}

		if ((billingProviderInformation == null)
				|| (billingProviderInformation.getClaim().getClaimIndex() != claim.getClaimIndex())) {
			logger.info("BillingProviderServiceImpl.getBillingProviderResponse() No Billing provider information found for the Cliam Index: "
							+ claim.getClaimIndex());
		} else {
			logger.debug("BillingProviderServiceImpl.getBillingProviderResponse() billingProviderInformation is : "+billingProviderInformation.toString());
			billingProviderResponse = new ProviderInfoResponse();
			billingProviderResponse.setAddressLine1(billingProviderInformation.getAddressLine1());
			billingProviderResponse.setAddressLine2(billingProviderInformation.getAddressLine2());
			billingProviderResponse.setCity(billingProviderInformation.getCity());
			billingProviderResponse.setContactName(billingProviderInformation.getContactName());
			billingProviderResponse.setEmail(billingProviderInformation.getEMail());
			billingProviderResponse.setFaxNumber(billingProviderInformation.getFaxNumber());
			billingProviderResponse.setLastName(billingProviderInformation.getLastName());
			billingProviderResponse.setPhoneNumber(billingProviderInformation.getPhoneNumber());
			billingProviderResponse.setProviderNpi(billingProviderInformation.getProviderNpi());
			billingProviderResponse.setTaxId(billingProviderInformation.getProviderTin());
			billingProviderResponse.setState(billingProviderInformation.getState());
			billingProviderResponse.setZipCode(billingProviderInformation.getZipCode());
			
			if (billingProviderInformation.getProviderType().toString()
					.equalsIgnoreCase(ClaimDetailsConstants.BILLING_PROVIDER_TYPE)) {
				return billingProviderResponse;
			}
		}
		logger.debug("BillingProviderServiceImpl.getBillingProviderResponse() billingProviderResponse is :"+billingProviderResponse);
		logger.info("BillingProviderServiceImpl.getBillingProviderResponse() returning back to the controller");
		return billingProviderResponse;
	}

}
