package gov.va.med.fee.service.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Set;

import org.springframework.beans.factory.annotation.Autowired;

import gov.va.med.domain.fee.AppRole;
import gov.va.med.domain.fee.AppUser;
import gov.va.med.domain.fee.UserRoleUsages;
import gov.va.med.fee.dao.IAppUserRepository;


public abstract class BaseService {

	@Autowired
	IAppUserRepository appUserRepository;
	
	protected boolean hasRole(String appUserName, String[] appUserRoles) {
		List<AppUser> userList = appUserRepository.findByAppUserName(appUserName);
		AppUser appUser = null;
		if (userList != null && !userList.isEmpty()) {
			appUser = userList.get(0);
		}

		if (appUser != null) {
			Set<UserRoleUsages> roles = appUser.getUserRoleUsages();

			for (UserRoleUsages uru : roles) {
				AppRole appRole = uru.getAppRole();
				if (Arrays.asList(appUserRoles).contains(appRole.getRoleName())) {
					return true;
				}
			}
		}
		return false;
	}
}
