package gov.va.med.fee.service.impl;

import static java.util.stream.Collectors.toList;

import java.util.Date;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import gov.va.med.domain.fee.AppUserRequest;
import gov.va.med.fee.dao.IAppUserRequestRepository;
import gov.va.med.fee.exceptions.AppUserRequestNotFoundException;
import gov.va.med.fee.model.AppUserRequestDTO;
import gov.va.med.fee.service.IAppUserRequestService;

@Service
@Transactional
public class AppUserRequestServiceImpl implements IAppUserRequestService{

	public static final Logger logger = LogManager.getLogger(AppUserRequestServiceImpl.class);
	
	@Autowired
	IAppUserRequestRepository iAppUserRequestRepository;
	
	@Override
	public AppUserRequestDTO create(AppUserRequestDTO appUserRequestDTO) {
		appUserRequestDTO.setCreatedBy("FPPS");
		appUserRequestDTO.setDateCreated(new Date());
		AppUserRequest appUserRequest = iAppUserRequestRepository.save(convertToPersistedModel(appUserRequestDTO));
		return convertToDTO(appUserRequest);
	}

	@Override
	public AppUserRequestDTO delete(long id) throws AppUserRequestNotFoundException {
		AppUserRequest appUserRequest = iAppUserRequestRepository.findOne(id);
		
		if (appUserRequest == null)
			throw new AppUserRequestNotFoundException();
		
		iAppUserRequestRepository.delete(appUserRequest);
		return convertToDTO(appUserRequest);	
	}

	@Override
	public List<AppUserRequestDTO> findAll() {
		return convertToDTOs(iAppUserRequestRepository.findAll());
	}

	@Override
	public AppUserRequestDTO update(AppUserRequestDTO appUserRequest) throws AppUserRequestNotFoundException {
		AppUserRequest updatedAppUserRequest = iAppUserRequestRepository.findOne(appUserRequest.getAppUserRequestId());
		
		if (updatedAppUserRequest == null)
			throw new AppUserRequestNotFoundException();
		
		updatedAppUserRequest.setUserName(appUserRequest.getUserName());
		updatedAppUserRequest.setFirstName(appUserRequest.getFirstName());
		updatedAppUserRequest.setMiddleName(appUserRequest.getMiddleName());
		updatedAppUserRequest.setLastName(appUserRequest.getLastName());
		updatedAppUserRequest.setPhoneNumber(appUserRequest.getPhoneNumber());
		updatedAppUserRequest.setEmailAddress(appUserRequest.getEmailAddress());
		updatedAppUserRequest.setEnabled(appUserRequest.getEnabled());
		updatedAppUserRequest.setRequestRoles(appUserRequest.getRequestRoles());
		updatedAppUserRequest.setRequestFacilities(appUserRequest.getRequestFacilities());
		updatedAppUserRequest.setModifiedBy("FPPS");
		updatedAppUserRequest.setDateModified(new Date());

		return convertToDTO(updatedAppUserRequest);
	}

	@Override
	public AppUserRequestDTO findById(long id) {
		AppUserRequest appUserRequest = iAppUserRequestRepository.findOne(id);

		return convertToDTO(appUserRequest);
	}

	private AppUserRequestDTO convertToDTO(AppUserRequest appUserRequest) {
		AppUserRequestDTO appUserRequestDTO = new AppUserRequestDTO();
		appUserRequestDTO.setAppUserRequestId(appUserRequest.getAppUserRequestId());
		appUserRequestDTO.setCreatedBy(appUserRequest.getCreatedBy());
		appUserRequestDTO.setDateCreated(appUserRequest.getDateCreated());
		appUserRequestDTO.setDateModified(appUserRequest.getDateModified());
		appUserRequestDTO.setDeactivationReasonCd(appUserRequest.getDeactivationReasonCd());
		appUserRequestDTO.setDeactivationComments(appUserRequest.getDeactivationComments());
		appUserRequestDTO.setEmailAddress(appUserRequest.getEmailAddress());
		appUserRequestDTO.setEnabled(appUserRequest.getEnabled());
		appUserRequestDTO.setFirstName(appUserRequest.getFirstName());
		appUserRequestDTO.setLastLoginDate(appUserRequest.getLastLoginDate());
		appUserRequestDTO.setLastName(appUserRequest.getLastName());
		appUserRequestDTO.setMiddleName(appUserRequest.getMiddleName());
		appUserRequestDTO.setModifiedBy(appUserRequest.getModifiedBy());
		appUserRequestDTO.setPhoneNumber(appUserRequest.getPhoneNumber());
		appUserRequestDTO.setRequestFacilities(appUserRequest.getRequestFacilities());
		appUserRequestDTO.setRequestRoles(appUserRequest.getRequestRoles());
		appUserRequestDTO.setRequestStatus(appUserRequest.getRequestStatus());
		appUserRequestDTO.setRequestType(appUserRequest.getRequestType());
		appUserRequestDTO.setUserName(appUserRequest.getUserName());
		
		
		return appUserRequestDTO;
	}
	
	private AppUserRequest convertToPersistedModel(AppUserRequestDTO appUserRequestDTO) {
		AppUserRequest appUserRequest = new AppUserRequest();
		appUserRequest.setAppUserRequestId(appUserRequestDTO.getAppUserRequestId());
		appUserRequest.setCreatedBy(appUserRequestDTO.getCreatedBy());
		appUserRequest.setDateCreated(appUserRequestDTO.getDateCreated());
		appUserRequest.setDateModified(appUserRequestDTO.getDateModified());
		appUserRequest.setDeactivationReasonCd(appUserRequestDTO.getDeactivationReasonCd());
		appUserRequest.setDeactivationComments(appUserRequestDTO.getDeactivationComments());
		appUserRequest.setEmailAddress(appUserRequestDTO.getEmailAddress());
		appUserRequest.setEnabled(appUserRequestDTO.getEnabled());
		appUserRequest.setFirstName(appUserRequestDTO.getFirstName());
		appUserRequest.setLastLoginDate(appUserRequestDTO.getLastLoginDate());
		appUserRequest.setLastName(appUserRequestDTO.getLastName());
		appUserRequest.setMiddleName(appUserRequestDTO.getMiddleName());
		appUserRequest.setModifiedBy(appUserRequestDTO.getModifiedBy());
		appUserRequest.setPhoneNumber(appUserRequestDTO.getPhoneNumber());
		appUserRequest.setRequestFacilities(appUserRequestDTO.getRequestFacilities());
		appUserRequest.setRequestRoles(appUserRequestDTO.getRequestRoles());
		appUserRequest.setRequestStatus(appUserRequestDTO.getRequestStatus());
		appUserRequest.setRequestType(appUserRequestDTO.getRequestType());
		appUserRequest.setUserName(appUserRequestDTO.getUserName());		
		return appUserRequest;
	}
	
    private List<AppUserRequestDTO> convertToDTOs(List<AppUserRequest> appUserRequest) {
        return appUserRequest.stream()
                .map(this::convertToDTO)
                .collect(toList());
    }
}
