/**
 * 
 */
package gov.va.med.fee.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import gov.va.med.domain.fee.AdjustmentGroup;
import gov.va.med.domain.fee.AdjustmentReason;
import gov.va.med.fee.dao.IAdjustmentGroupRepository;
import gov.va.med.fee.dao.IAdjustmentReasonRepository;
import gov.va.med.fee.dao.IAdjustmentsRepository;
import gov.va.med.fee.exceptions.GenericException;
import gov.va.med.fee.model.response.AdjustmentGroupDTO;
import gov.va.med.fee.model.response.AdjustmentReasonDTO;
import gov.va.med.fee.model.response.AdjustmentReasonResponse;
import gov.va.med.fee.model.response.AdjustmentsResponse;
import gov.va.med.fee.model.response.AdjustmentsResponses;
import gov.va.med.fee.model.response.DisapproveClaimsReason;
import gov.va.med.fee.service.IAdjustmentsService;

/**
 * @author Vamsi Krishna Gangarapu
 *
 */
@Service
public class AdjustmentsServiceImpl implements IAdjustmentsService {

	private static final Logger logger = LogManager.getLogger(AdjustmentsServiceImpl.class);

	@Autowired
	IAdjustmentsRepository iDisClaimRepository;
	
	@Autowired
	IAdjustmentReasonRepository iAdjustmentReasonRepository;
	
	@Autowired
	IAdjustmentGroupRepository iAdjustmentGroupRepository;

	@Override
	public AdjustmentsResponse populateAdjustmentReasons() throws GenericException {
		List<DisapproveClaimsReason> adjustmentReasonsList = new LinkedList<DisapproveClaimsReason>();
		List<DisapproveClaimsReason> tmp = new LinkedList<DisapproveClaimsReason>();
		
		AdjustmentsResponse adjustmentsResponse = null;

		List<AdjustmentReasonResponse> adjReasonList = new ArrayList<AdjustmentReasonResponse>();

		logger.info("GenericResponseServiceImpl.populateAdjustmentReasons() - getting all the distict reason codes.");

		adjReasonList = iDisClaimRepository.populateAdjustmentReasons();

		for (AdjustmentReasonResponse reason : adjReasonList) {
			DisapproveClaimsReason claimsReason = new DisapproveClaimsReason();
			if (reason.getAdjustmentReasonCd().matches("^[A-Z].*")) {
				claimsReason.setCode(reason.getAdjustmentReasonCd());
				claimsReason.setClaimReasons(reason.getDescription());
				tmp.add(claimsReason);
			} else {
				claimsReason.setCode(reason.getAdjustmentReasonCd());
				claimsReason.setClaimReasons(reason.getDescription());
				adjustmentReasonsList.add(claimsReason);
			}
		}

		Collections.sort(adjustmentReasonsList, new Comparator<DisapproveClaimsReason>() {

			@Override
			public int compare(DisapproveClaimsReason o1, DisapproveClaimsReason o2) {
				// return o1.getClaimReasons().compareTo(o2.getClaimReasons());
				return o1.getCode().compareTo(o2.getCode());
			}
		});

		Collections.sort(tmp, new Comparator<DisapproveClaimsReason>() {

			@Override
			public int compare(DisapproveClaimsReason o1, DisapproveClaimsReason o2) {
				// return o1.getClaimReasons().compareTo(o2.getClaimReasons());
				return o1.getCode().compareTo(o2.getCode());
			}
		});
		adjustmentReasonsList.addAll(tmp);
		adjustmentsResponse = new AdjustmentsResponse();
		adjustmentsResponse.setAdjustmentReasons(adjustmentReasonsList);

		return adjustmentsResponse;
	}

	@Override
	public AdjustmentsResponse populateAdjustmentGroups() throws GenericException {
		List<DisapproveClaimsReason> adjustmentGroupsList = new LinkedList<DisapproveClaimsReason>();

		List<AdjustmentReasonResponse> adjReasonList = new ArrayList<AdjustmentReasonResponse>();

		AdjustmentsResponse adjustmentsResponse = null;
		
		logger.info("GenericResponseServiceImpl.populateAdjustmentReasons() - getting all the distict reason codes.");

		adjReasonList = iDisClaimRepository.populateAdjustmentGroups();

		for (AdjustmentReasonResponse reason : adjReasonList) {
			DisapproveClaimsReason claimsReason = new DisapproveClaimsReason();
			claimsReason.setCode(reason.getAdjustmentReasonCd());
			claimsReason.setClaimReasons(reason.getDescription());
			adjustmentGroupsList.add(claimsReason);
		}

		Collections.sort(adjustmentGroupsList, new Comparator<DisapproveClaimsReason>() {

			@Override
			public int compare(DisapproveClaimsReason o1, DisapproveClaimsReason o2) {
				// return o1.getClaimReasons().compareTo(o2.getClaimReasons());
				return o1.getCode().compareTo(o2.getCode());
			}
		});
		adjustmentsResponse = new AdjustmentsResponse();
		adjustmentsResponse.setAdjustmentGroups(adjustmentGroupsList);
		return adjustmentsResponse;
	}

	@Override
	public String getAdjustmentReason(String code) {
		//String adjustmentReason = iDisClaimRepository.
		return null;
	}

	@Override
	public String getAdjustmentGroup(String code) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AdjustmentsResponses getAdjustmentGroups() throws GenericException{
		
		List<AdjustmentGroup> adjustmentGroupList = iAdjustmentGroupRepository.findAll();
		AdjustmentsResponses adjustmentsResponses = convertToAdjustmentGroupResponse(adjustmentGroupList);
				
		return adjustmentsResponses;
	}
	
	private AdjustmentsResponses convertToAdjustmentGroupResponse(List<AdjustmentGroup> adjustmentGroupList) {
		AdjustmentsResponses adjustmentsResponses = new AdjustmentsResponses();
		List<AdjustmentGroupDTO> adjustmentGroupDTOList = new ArrayList<AdjustmentGroupDTO>();
		for(AdjustmentGroup adjustmentGroup : adjustmentGroupList) {
			AdjustmentGroupDTO adjustmentGroupDTO = new AdjustmentGroupDTO();
			adjustmentGroupDTO.setCode(adjustmentGroup.getAdjustmentGroupCd());
			adjustmentGroupDTO.setDescription(adjustmentGroup.getDescription());
			/*adjustmentGroupDTO.setFeeUsageFlag(adjustmentGroup.getFeeUsageFlag());
			adjustmentGroupDTO.setCreatedBy(adjustmentGroup.getCreatedBy());
			adjustmentGroupDTO.setDateCreated(adjustmentGroup.getDateCreated());*/
			
			adjustmentGroupDTOList.add(adjustmentGroupDTO);
		}
		
		adjustmentsResponses.setAdjustmentGroups(adjustmentGroupDTOList);
		
		return adjustmentsResponses;
	}
	
	@Override
	public AdjustmentsResponses getAdjustmentReasonsByGroupCode(String groupCode) throws GenericException{
		
		List<AdjustmentReason> adjustmentReasonList = iDisClaimRepository.findAdjustmentReasonByGroupCode(groupCode);
		
		AdjustmentsResponses adjustmentsResponses = convertToAdjustmentReasonResponse(adjustmentReasonList);
		
		return adjustmentsResponses;
	}
	
	private AdjustmentsResponses convertToAdjustmentReasonResponse(List<AdjustmentReason> adjustmentReasonList) {
		AdjustmentsResponses adjustmentsResponses = new AdjustmentsResponses();
		
		List<AdjustmentReasonDTO> adjustmentReasonDTOList = new ArrayList<AdjustmentReasonDTO>();
		for(AdjustmentReason adjustmentReason : adjustmentReasonList) {
			AdjustmentReasonDTO adjustmentReasonDTO = new AdjustmentReasonDTO();
			adjustmentReasonDTO.setCode(adjustmentReason.getAdjustmentReasonCd());
			adjustmentReasonDTO.setDescription(adjustmentReason.getDescription());
			/*adjustmentReasonDTO.setFeeUsageFlag(adjustmentReason.getFeeUsageFlag());
			adjustmentReasonDTO.setActiveFlag(adjustmentReason.getActiveFlag());
			adjustmentReasonDTO.setCreatedBy(adjustmentReason.getCreatedBy());
			adjustmentReasonDTO.setDateCreated(adjustmentReason.getDateCreated());*/
			
			adjustmentReasonDTOList.add(adjustmentReasonDTO);
		}
		
		adjustmentsResponses.setAdjustmentReasons(adjustmentReasonDTOList);
		
		return adjustmentsResponses;
	}
}
