/**
 * 
 */
package gov.va.med.fee.service.impl;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import gov.va.med.domain.fee.Claim;
import gov.va.med.domain.fee.HealthcareInfoCode;
import gov.va.med.domain.fee.PayerInfo;
import gov.va.med.domain.fee.ProviderInfo;
import gov.va.med.fee.constants.ClaimDetailsConstants;
import gov.va.med.fee.dao.IAdditionalInfoRepository;
import gov.va.med.fee.dao.IAdditionalInfoRepositoryTemplate;
import gov.va.med.fee.dao.IAttendingPhysicianRepository;
import gov.va.med.fee.dao.ICarcDetailRepositoryTemplate;
import gov.va.med.fee.dao.IClaimPaymentRepository;
import gov.va.med.fee.dao.IClaimRepository;
import gov.va.med.fee.dao.IDiagnosisCodeRepository;
import gov.va.med.fee.model.response.AdditionalInfoResponse;
import gov.va.med.fee.model.response.ClaimPaymentResponse;
import gov.va.med.fee.service.IAdditionalInfoService;

/**
 * @author Vamsi Krishna Gangarapu
 *
 */
@Service
public class AdditionalInfoServiceImpl implements IAdditionalInfoService {

	private static final Logger logger = LogManager.getLogger(AdditionalInfoServiceImpl.class);

	@Autowired
	IClaimRepository iClaimRepository;

	@Autowired
	IAdditionalInfoRepositoryTemplate iAdditionalInfoRepositoryTemplate;

	@Autowired
	IAdditionalInfoRepository iAdditionalInfoRepository;

	@Autowired
	IAttendingPhysicianRepository iAttendingPhysicianRepository;

	@Autowired
	IClaimPaymentRepository iClaimPaymentrepository;

	@Autowired
	IDiagnosisCodeRepository iDiagnosisCodeRepository;

	@Autowired
	ICarcDetailRepositoryTemplate iCarDetailRepositoryTemplate;

	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.fee.service.IAdditionalInfoService#getAdditionalInfoDetails(
	 * gov.va.med.domain.fee.Claim)
	 * 
	 * @Param Claim
	 */
	@Override
	public AdditionalInfoResponse getAdditionalInfoDetails(Claim claim) {
		logger.info(
				"AdditionalInfoServiceImpl.getAdditionalInfoDetails() getting the AdditionalInfo details for claim index :"
						+ claim.getClaimIndex());

		AdditionalInfoResponse additionalInfoResponse = new AdditionalInfoResponse();
		String sTotal = "";
		SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy");
		int diffInDays = 0;
		BigDecimal TotalClaimAmountPaid = null;
		List<String> detailsList = new ArrayList<>();

		List<PayerInfo> payerInfo = new ArrayList<PayerInfo>();
		try {
			String[] payerType = { "SECONDARY", "TERTIARY" };

			if (claim.getEndServiceDate() != null && claim.getBeginServiceDate() != null) {
				diffInDays = (int) (((claim.getEndServiceDate().getTime() - claim.getBeginServiceDate().getTime())
						/ (1000 * 60 * 60 * 24)) + 1);
			}

			for (int i = 0; i < (payerType.length); i++) {
				logger.info(
						"AdditionalInfoServiceImpl.getAdditionalInfoDetails() invoking the iAdditionalInfoRepository.findPayerInfoByClaimIndex()");
				payerInfo.add(iAdditionalInfoRepository.findPayerInfoByClaimIndex(claim.getClaimIndex(), payerType[i]));
			}
			try {
				logger.info(
						"AdditionalInfoServiceImpl.getAdditionalInfoDetails() invoking the iAdditionalInfoRepositoryTemplate.getAdditionalTabInfo()");
				ClaimPaymentResponse claimPaymentResponse = iAdditionalInfoRepositoryTemplate
						.getAdditionalTabInfo(claim.getClaimIndex());
				if (claimPaymentResponse != null) {
					detailsList = getDetails(claimPaymentResponse);
				}
			} catch (NullPointerException e) {
				logger.info(
						"iAdditionalInfoRepositoryTemplate.getAdditionalTabInfo() getting Null Pointer due to lack of data");
				logger.error(
						"iClaimPaymentrepository.getAdditionalTabInfo() getting Null Pointer due to lack of data for data, full stacktrace follows: "
								+ e);
			}

			logger.info(
					"AdditionalInfoServiceImpl.getAdditionalInfoDetails() invoking the iAttendingPhysicianRepository.findOneByType()");
			ProviderInfo providerInfo = iAttendingPhysicianRepository.findOneByType(claim.getClaimIndex(),
					"ATTENDING PHYSICIAN");
			logger.info(
					"AdditionalInfoServiceImpl.getAdditionalInfoDetails() invoking the DiagnosisCodeRepository.findProviderDRGByClaim()");
			HealthcareInfoCode healthcareInfoCode = iDiagnosisCodeRepository
					.findProviderDRGByClaim(claim.getClaimIndex());

			try {
				logger.info(
						"AdditionalInfoServiceImpl.getAdditionalInfoDetails() invoking the iClaimPaymentrepository.findSumOfPaidAmount()");
				TotalClaimAmountPaid = iClaimPaymentrepository.findSumOfPaidAmount(claim.getClaimIndex());
				DecimalFormat df = new DecimalFormat("$#0.00");
				float fTemp = TotalClaimAmountPaid.floatValue();
				float fTotalPaidAmt = fTemp;
				sTotal = df.format(fTotalPaidAmt);
			} catch (NullPointerException e) {
				logger.info(
						"iClaimPaymentrepository.findSumOfPaidAmount() getting Null Pointer due to lack of data for sum");
				logger.error(
						"iClaimPaymentrepository.findSumOfPaidAmount() getting Null Pointer due to lack of data for sum, full stacktrace follows: "
								+ e);
			}

			if (claim.getServiceType().getServiceTypeCd() != null) {
				if (claim.getServiceType().getServiceTypeCd().equals(ClaimDetailsConstants.INSTITUTIONAL_CLAIM)) {

					if (payerInfo.size() >= 1) {
						if ((payerInfo.get(0) != null)) {
							if (payerInfo.get(0).getPlanId() != null) {
								additionalInfoResponse
										.setOtherInsuranceNumber_SecondaryPayer(payerInfo.get(0).getPlanId());
							}
							if (payerInfo.get(0).getPlanName() != null) {
								additionalInfoResponse
										.setOtherInsurancePlan_SecondaryPayer(payerInfo.get(0).getPlanName());
							}
						}
						if ((payerInfo.get(1) != null)) {
							if (payerInfo.get(1).getPlanId() != null) {
								additionalInfoResponse
										.setOtherInsuranceNumber_TertiaryPayer(payerInfo.get(1).getPlanId());
							}
							if (payerInfo.get(1).getPlanName() != null) {
								additionalInfoResponse
										.setOtherInsurancePlan_TertiaryPayer(payerInfo.get(1).getPlanName());
							}
						}
					} else {
						logger.info(
								"AdditionalInfoServiceImpl.getAdditionalInfoDetails() No Additional Seconday or Teritary payer information found for the Cliam Index: "
										+ claim.getClaimIndex());
					}

					if (claim.getDischargeDate() != null) {
						additionalInfoResponse.setDischargeDate(formatter.format(claim.getDischargeDate()));
					}
					if (claim.getAdmissionDate() != null) {
						additionalInfoResponse.setAdmissionDate(formatter.format(claim.getAdmissionDate()));
					}

					if (providerInfo != null) {
						if ((providerInfo.getFirstName() != null) || !(providerInfo.getLastName() != null)
								|| !(providerInfo.getMiddleName() != null)) {
							additionalInfoResponse.setAttendingPhysician(
									providerInfo.getFirstName() + " " + providerInfo.getLastName() + " "
											+ providerInfo.getMiddleName() + " " + providerInfo.getNameSuffix());
						}
					}
					additionalInfoResponse.setCoveredDays(String.valueOf(diffInDays));
					if (healthcareInfoCode != null) {
						if (healthcareInfoCode.getHi01procCd() != null) {
							additionalInfoResponse.setProviderDrg(healthcareInfoCode.getHi01procCd());
						}
					}
					if (!(detailsList.isEmpty())) {
						additionalInfoResponse.setTreasuryPaymentDate_Pd(detailsList.get(2));
						additionalInfoResponse.setTotalPaidAmtPerPD(detailsList.get(1));
						additionalInfoResponse.setCheck_EFT_TRN(detailsList.get(0));
					}

				} else if (claim.getServiceType().getServiceTypeCd().equals(ClaimDetailsConstants.PROFESSIONAL_CLAIM)) {
					if (payerInfo.size() >= 1) {
						if ((payerInfo.get(0) != null)) {
							if (payerInfo.get(0).getPlanId() != null) {
								additionalInfoResponse
										.setOtherInsuranceNumber_SecondaryPayer(payerInfo.get(0).getPlanId());
							}
							if (payerInfo.get(0).getPlanName() != null) {
								additionalInfoResponse
										.setOtherInsurancePlan_SecondaryPayer(payerInfo.get(0).getPlanName());
							}
						}
						if ((payerInfo.get(1) != null)) {
							if (payerInfo.get(1).getPlanId() != null) {
								additionalInfoResponse
										.setOtherInsuranceNumber_TertiaryPayer(payerInfo.get(1).getPlanId());
							}
							if (payerInfo.get(1).getPlanName() != null) {
								additionalInfoResponse
										.setOtherInsurancePlan_TertiaryPayer(payerInfo.get(1).getPlanName());
							}
						}
					} else {
						logger.info(
								"AdditionalInfoServiceImpl.getAdditionalInfoDetails() No Additional Seconday or Teritary payer information found for the Cliam Index: "
										+ claim.getClaimIndex());
					}
					additionalInfoResponse.setAmbulanceTransportReason(claim.getAmbulanceTransportText());
					additionalInfoResponse.setTotalClaimAmountPaid(sTotal);
					if (!(detailsList.isEmpty())) {
						additionalInfoResponse.setTreasuryPaymentDate_Pd(detailsList.get(2));
						additionalInfoResponse.setTotalPaidAmtPerPD(detailsList.get(1));
						additionalInfoResponse.setCheck_EFT_TRN(detailsList.get(0));
					}
				} else if (claim.getServiceType().getServiceTypeCd().equals(ClaimDetailsConstants.DENTAL_CLAIM)) {
					if (!(detailsList.isEmpty())) {
						additionalInfoResponse.setTreasuryPaymentDate_Pd(detailsList.get(2));
						additionalInfoResponse.setTotalPaidAmtPerPD(detailsList.get(1));
						additionalInfoResponse.setCheck_EFT_TRN(detailsList.get(0));
					}
				} else {
					logger.info(
							"AdditionalInfoServiceImpl.getAdditionalInfoDetails() : additional_information_not_found for "
									+ claim.getServiceType().getServiceTypeCd() + " claim with" + "ClaimIndex: "
									+ claim.getClaimIndex());

					logger.error(
							"AdditionalInfoServiceImpl.getAdditionalInfoDetails() : additional_information_not_found for "
									+ claim.getServiceType().getServiceTypeCd() + " claim with" + "ClaimIndex: "
									+ "ClaimIndex: " + claim.getClaimIndex());

				}
			}
		} catch (Exception e) {
			logger.error("AdditionalInfoServiceImpl.getAdditionalInfoDetails() internal_server_error for "
					+ claim.getClaimIndex() + " " + e);
		}

		return additionalInfoResponse;
	}

	/**
	 * @param claimPaymentResponse
	 * @return
	 */
	private List<String> getDetails(ClaimPaymentResponse claimPaymentResponse) {

		List<String> detailsList = new ArrayList<>();

		SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy");
		DecimalFormat df = new DecimalFormat("$#0.00");
		StringBuffer sCheckNumber = new StringBuffer();
		StringBuffer sAmt = new StringBuffer();
		StringBuffer sDate = new StringBuffer();
		String temp = "";
		final String COMMA = ", ";
		BigDecimal paidAmount = null;

		// checkNumber
		// viewClaim.claimPaymentBean.checkNumber
		if (claimPaymentResponse.getCheckNumber() != null) {
			temp = (String) claimPaymentResponse.getCheckNumber();
			sCheckNumber.append(temp + COMMA);
		} else {
			sCheckNumber.setLength(0);
		}

		if (claimPaymentResponse.getPaidAmountFormatted() != null) {
			try {
				paidAmount = (BigDecimal) claimPaymentResponse.getPaidAmountFormatted();
				if ((paidAmount.floatValue() > 0.00) || (paidAmount.floatValue() < 0.00)
						|| (paidAmount.floatValue() == 0.00)) {
					temp = df.format(paidAmount.floatValue());
					sAmt.append(temp + COMMA);
				}
			} catch (Exception ex) {
				logger.info("AdditionalInfoServiceImpl.getDetails() ERROR WITH paidAmount: " + ex.getMessage());
				logger.error("AdditionalInfoServiceImpl.getDetails() ERROR WITH paidAmount: " + ex.getMessage());
				logger.error(
						"AdditionalInfoServiceImpl.getDetails() thew an exception with paidAmount and full stacktrace follows: "
								+ ex);
			}
		}

		// trunc(check_date)
		// viewClaim.claimPaymentBean.treasuryPaymentDateFormatted
		if (claimPaymentResponse.getTreasuryPaymentDateFormatted() != null) {
			try {
				java.sql.Timestamp x = (java.sql.Timestamp) claimPaymentResponse.getTreasuryPaymentDateFormatted();
				temp = formatter.format(x);
				sDate.append(temp + COMMA);
			} catch (Exception ex) {
				logger.info("AdditionalInfoServiceImpl.getDetails() ERROR WITH paymentDate: " + ex.getMessage());
				logger.error("AdditionalInfoServiceImpl.getDetails() ERROR WITH paymentDate: " + ex.getMessage());
				logger.error(
						"AdditionalInfoServiceImpl.getDetails() thew an exception with payments and full stacktrace follows: "
								+ ex);
			}

		}

		if (sCheckNumber.length() > 0) {
			sCheckNumber = new StringBuffer(sCheckNumber.deleteCharAt(sCheckNumber.length() - 2));
			detailsList.add(sCheckNumber.toString());
		}

		if (sAmt.length() > 0) {
			sAmt = new StringBuffer(sAmt.deleteCharAt(sAmt.length() - 2));
			detailsList.add(sAmt.toString());
		}

		if (sDate.length() > 0) {
			sDate = new StringBuffer(sDate.deleteCharAt(sDate.length() - 2));
			detailsList.add(sDate.toString());
		}

		return detailsList;

	}
}