package gov.va.med.fee.service;

import java.util.List;

import gov.va.med.fee.exceptions.GenericException;
import gov.va.med.fee.model.request.ContactInfoRequest;
import gov.va.med.fee.model.request.VaFacilityRequest;
import gov.va.med.fee.model.request.VaFacilitySearchRequest;
import gov.va.med.fee.model.request.ZipCodeRequest;
import gov.va.med.fee.model.response.GenericResponse;
import gov.va.med.fee.model.response.VaFacilities;
import gov.va.med.fee.model.response.VaFacilityResponse;
import gov.va.med.fee.model.response.VaFacilityTypeResponse;
import gov.va.med.fee.model.response.VaFacilityVisnResponse;

public interface IVaFacilityService {

	/*
	 * This method can be used to add a facility.
	 * 
	 * @param this method takes a AddFacilityRequest object as parameter
	 * 
	 * @return this method returns an integer of 1 or 0
	 * 
	 * @throws GenericException
	 */
	public int addVaFacility(VaFacilityRequest request) throws GenericException;

	/*
	 * This method can be used to get all the Visons
	 * 
	 * @return a list of Visn name
	 * 
	 * @throws GenericException
	 */
	public List<VaFacilityVisnResponse> getAllVisns() throws GenericException;

	/*
	 * This method can be used to get all the facility type
	 * 
	 * @return a list to facility type
	 * 
	 * @throws GenericException
	 */
	public List<VaFacilityTypeResponse> getAllVaFacilityType() throws GenericException;

	/**
	 * @author Vamsi Krishna Gangarapu
	 * 
	 * @param this
	 *            method takes a AddFacilityRequest object as parameter
	 * @return this method returns an integer of 1 or 0
	 * @throws GenericException
	 * 
	 */
	public boolean modifyStation(VaFacilityRequest request) throws GenericException;
	
	/**
	 * @author Vamsi Krishna Gangarapu
	 * 
	 * @param stationName
	 * @return Station Information
	 * @throws GenericException
	 */
	public VaFacilityRequest getStationInfo(String stationName) throws GenericException;
	
	/**
	 * 
	 * @return Json Array of VaFacilities
	 * @throws GenericException 
	 */
	public List<VaFacilities> getAllVaFacilites() throws GenericException;

	/**
	 * @author Vamsi Krishna Gangarapu
	 * 
	 * @param VaFacilitySearchRequest
	 * @return GenericResponse that has the pagination
	 * @throws GenericException
	 * 
	 */
	public GenericResponse getSearchVisn(VaFacilitySearchRequest searchRequest) throws GenericException;

	/**
	 * @author Vamsi Krishna Gangarapu
	 * 
	 * @param stationName
	 * @return boolean value with True or False True for Station exists False
	 *         for Station do not exists
	 * @throws GenericException
	 */
	public boolean checkVaFacility(String stationName) throws GenericException;

	/**
	 * @author Vamsi Krishna Gangarapu
	 * 
	 * @param ContactInfoRequest
	 * @return boolean value with True or False True for Station exists False
	 *         for Station do not exists
	 * @throws GenericException
	 */
	public boolean postContactInfo(ContactInfoRequest contactInfo) throws GenericException;

	/**
	 * @author Vamsi Krishna Gangarapu
	 * 
	 * @param stationNumber
	 * @return list of contact information
	 * @throws GenericException
	 */
	public List<ContactInfoRequest> getContactInfo(String stationNumber) throws GenericException;

	/**
	 * @author Vamsi Krishna Gangarapu
	 * 
	 * @param stationNumber
	 * @return get all the information related to the station along with Contact Info and zip code
	 * @throws GenericException
	 */
	public VaFacilityResponse getVaFacilityInfo(String stationNumber) throws GenericException;
	
	/**
	 * 
	 * @param visnNumber
	 * @return get all the information related to the visn number along with Station Info
	 * @throws GenericException
	 */
	public VaFacilityVisnResponse getVisnInfo(Long visnNumber) throws GenericException;
	
	/**
	 * 
	 * @param typeNumber
	 * @return get all the information related to the type number along with Station Info
	 * @throws GenericException
	 */
	public VaFacilityTypeResponse getStationTypeInfo(String typeNumber) throws GenericException;

	/**
	 * @author Vamsi Krishna Gangarapu
	 * 
	 * @param contactInfoId
	 * @return boolean value with True or False True for contactInfo successfully deleted False
	 *         for contactInfo not successfully deleted
	 * @throws GenericException
	 */
	public boolean deleteContactInfo(Long contactInfoId) throws GenericException;

	/**
	 * @author Vamsi Krishna Gangarapu
	 * 
	 * @param zipCode
	 * @return boolean value with True or False True for zipCode exists False
	 *         for zipCode do not exists
	 * @throws GenericException
	 */
	public boolean checkZipExists(String zipCode) throws GenericException;

	// Station Maintenance - Add ZIP Code to a va facility
	public Boolean addZipCode(ZipCodeRequest request) throws GenericException;

	// Station Maintenance - Edit ZIP Code to a va facility
	public Boolean editZipCode(ZipCodeRequest request) throws GenericException;

	// Delete ZIP Code
	public Boolean removeZipCode(ZipCodeRequest request) throws GenericException;

	// Get ZIP Code list
	public List<ZipCodeRequest> getZipCodeList(String vaFacilityCd) throws GenericException;

	public boolean deleteStationInfo(String stationName) throws GenericException;

	

}