package gov.va.med.fee.service;

import java.util.List;

import gov.va.med.fee.exceptions.GenericException;
import gov.va.med.fee.model.request.RejectedClaimRequest;
import gov.va.med.fee.model.response.DisapproveClaims;
import gov.va.med.fee.model.response.DisapproveClaimsPage;

/**
 * 
 * @author vhaisbjahank
 * 
 *
 * @Modifiedauthor Vamsi Krishna Gangarapu
 * corrected populateAdjustmentReasons()
 * Added getClaimsToDisapprove() and disapproveClaim()
 *
 */

public interface IDisapproveService {
	
	/**
	 * This method will return all the claims that a user wants to disapprove by their claimIds
	 * @param claimIds
	 * @return a list of DisapproveClaims
	 * @throws GenericException
	 */
	DisapproveClaimsPage getClaimsToDisapprove(List<Long> claimIds) throws GenericException;
	
	/**
	 * 
	 * @return a list of reason codes
	 * @throws GenericException
	 */
	DisapproveClaimsPage populateAdjustmentReasons() throws GenericException;
	
	DisapproveClaimsPage disapproveClaim(DisapproveClaims disaaproveclaims) throws GenericException;
	
	public boolean okDisapprovals(List<RejectedClaimRequest> rejectedClaimRequestList, String userName) throws GenericException;
	
	public boolean reverseDisapprovals(List<RejectedClaimRequest> rejectedClaimRequestList, String userName) throws GenericException;
}
