package gov.va.med.fee.service;

import java.util.List;

import gov.va.med.fee.exceptions.GenericException;
import gov.va.med.fee.model.request.ClaimRequest;
import gov.va.med.fee.model.response.ClaimDetailsResponse;
import gov.va.med.fee.model.response.ClaimLineItems;
import gov.va.med.fee.model.response.ClaimRejectedResponse;
import gov.va.med.fee.model.response.ClaimResponse;

public interface IClaimService {
	List<ClaimResponse> getClaimsByStatus(ClaimRequest claimRequest, String claimStatus) throws GenericException;
	List<ClaimResponse> updateClaimsStatus(ClaimRequest claimRequest, String claimStatusCd) throws GenericException;
	ClaimDetailsResponse updateClaimStatus(ClaimRequest claimRequest, String claimStatusCd) throws GenericException;
	List<ClaimRejectedResponse> getClaimsRejected(ClaimRequest claimRequest, String claimStatus) throws GenericException;
	ClaimLineItems getClaimLineItems(long claimId) throws GenericException;
}
