/**
 *  @author Eyuel Taddese
 *
 */
package gov.va.med.fee.service;

import java.util.List;

import gov.va.med.domain.fee.AppUser;
import gov.va.med.fee.exceptions.GenericException;
import gov.va.med.fee.model.response.AuthenticationParamResponse;
import gov.va.med.fee.model.response.UserInfoResponse;
import gov.va.med.fee.model.response.UserStationDetails;

public interface IAuthenticatorService {
	public String getUsernameFromAspAuth(String guid) throws GenericException;
	boolean authenticate(String guid) throws GenericException;
	public UserInfoResponse getUserRoles() throws GenericException;
	AuthenticationParamResponse getAuthParams(String sessionId) throws Exception;
	public List<AppUser> getAppUsers();
	public AppUser getAppUser(String decryptedGuid)  throws GenericException;
	public UserStationDetails getUpdatedUserStationDetails(String userName) throws GenericException;
}
