/*
 * $Id: SelectableItem.java,v 1.2 2009/05/12 20:02:16 vhahacnguyes Exp $
 */
package gov.va.med.fee.report.util;

/**
 * Generic class for a selectable item (key, value).
 *
 * @author vhahacnguyes
 */
public class SelectableItem {

    /**
     * Creates a new instance of SelectableItem.
     */
    public SelectableItem() {
    }

    /**
     * Instantiates a new selectable item.
     *
     * @param key the key
     * @param value the value
     */
    public SelectableItem(final String key, final String value) {
        this.key = key;
        this.value = value;
    }

    /** Holds value of property key. */
    private String key;

    /**
     * Getter for property key.
     *
     * @return Value of property key.
     */
    public final String getKey() {
        return this.key;
    }

    /**
     * Setter for property key.
     *
     * @param key New value of property key.
     */
    public final void setKey(final String key) {
        this.key = key;
    }

    /** Holds value of property value. */
    private String value;

    /**
     * Getter for property value.
     *
     * @return Value of property value.
     */
    public final String getValue() {
        return this.value;
    }

    /**
     * Setter for property value.
     *
     * @param value New value of property value.
     */
    public final void setValue(final String value) {
        this.value = value;
    }

    /**
     * String representation.
     *
     * @return the string
     */
    public final String toString() {
        return new StringBuffer(this.getClass().getName())
            .append("[key=").append(key)
            .append(",value=").append(value).append("]")
            .toString();
    }

}
