/*
 * $Id: PropertiesUtil.java,v 1.2 2009/05/12 20:02:16 vhahacnguyes Exp $
 */
package gov.va.med.fee.report.util;

import java.io.InputStream;
import java.util.Properties;

/**
 * Loads properties file.
 *
 * @author vhahacnguyes
 */
public class PropertiesUtil {

        /**
     * Loads a property file based in class loader classpath.
     *
     * @param fileName the file name
     *
     * @return the properties
     */
    public final Properties load(final String fileName) {
        Properties result = null;
        ClassLoader loader = this.getClass().getClassLoader();
        InputStream is = null;
        try {
            is = loader.getResourceAsStream(fileName);
            result = new Properties();
            result.load(is);
        } catch (Exception e) {
            //log.error(e);
        } finally {
            if (is != null) {
                try {
                    is.close();
                } catch (Exception e) {
                    //log.error(e);
                }
            }
        }
        return result;
    }
}
