/*
 * $Id: ItemUtil.java,v 1.2 2009/05/12 20:02:16 vhahacnguyes Exp $
 */

package gov.va.med.fee.report.util;

import java.util.Date;
import java.util.Calendar;
import java.text.SimpleDateFormat;

/**
 * The Class ItemUtil.
 *
 * @author vhahacnguyes
 */
public final class ItemUtil {

    /** The Constant PLSQL_DATE_FORMAT. */
    private static final String PLSQL_DATE_FORMAT = "yyyy-MM-dd";

    /** The Constant DATE_FORMAT. */
    private static final SimpleDateFormat DATE_FORMAT =
        new SimpleDateFormat(PLSQL_DATE_FORMAT);

    /**
     * Creates a new instance of ItemUtils.
     */
    private ItemUtil() {
    }

    /**
     * Formats the items into format expected by the SQL
     * Items are separated by commas.
     *
     * @param items the items
     *
     * @return the string
     */
    public static String concatItems(final String[] items) {
        StringBuffer buff = new StringBuffer("(");
        buff.append(concatItemsNoPars(items));
        return buff.append(")").toString();
    }

    /**
     * Concat items no parentheses.
     *
     * @param items the items
     *
     * @return the string
     */
    public static String concatItemsNoPars(final String[] items) {
        StringBuffer buff = new StringBuffer("");
        if (items != null && items.length > 0) {
            for (int i = 0; i < items.length; i++) {
                if (i != 0) {
                    buff.append(",");
                }
                buff.append("'").append(items[i]).append("'");
            }
        }
        return buff.toString();
    }

    /**
     * Formats the items into format expected by the Crystal report.
     * Items are separated by commas.
     *
     * @param items the items
     *
     * @return the string
     */
    public static String concatItemsAddBrackets(final String[] items) {
        StringBuffer buff = new StringBuffer();
        if (items != null && items.length > 0) {
            for (int i = 0; i < items.length; i++) {
                if (i != 0) {
                    buff.append(",");
                }
                buff.append(addBrackets(items[i]));
            }
        }
        return buff.toString();
    }

    /**
     * Adds square backets around the item.
     *
     * @param item the item
     *
     * @return the string
     */
    public static String addBrackets(final String item) {
        return new StringBuffer("[").append(item).append("]").toString();
    }

    /**
     * Formats the date into format expected by Crytal Reports.
     *
     * @param date the date
     *
     * @return the string
     */
    public static String formatDate(final Date date) {
        String str = null;
        if (date != null) {
            Calendar d = Calendar.getInstance();
            d.setTime(date);
            int day = d.get(Calendar.DAY_OF_MONTH);
            int month = d.get(Calendar.MONTH) + 1;
            int year = d.get(Calendar.YEAR);
            str = new StringBuffer("Date(")
                .append(year).append(",")
                .append(formatDayMonth(month)).append(",")
                .append(formatDayMonth(day))
                .append(")")
                .toString();
        }
        return str;
    }

    /**
     * Formats into a form agreed with PL/SQL.
     *
     * @param date the date
     *
     * @return the string
     */
    public static String formatPLSQLDate(final Date date) {
        return DATE_FORMAT.format(date);
    }

    /**
     * Format day month.
     *
     * @param d the d
     *
     * @return the string
     */
    private static String formatDayMonth(final int d) {
        String dstr = Integer.toString(d);
        if (dstr.length() == 1) {
            return "0" + dstr;
        }
        return dstr;
    }

}
