/*
 * $Id: VitriaPreparer.java,v 1.13 2010/01/07 14:50:31 vhahacnguyes Exp $
 */
package gov.va.med.fee.report.jasper;

import gov.va.med.fee.model.request.SearchCriteriaRequest;
import gov.va.med.fee.report.DateValue;
import gov.va.med.fee.report.util.ItemUtil;

import java.text.SimpleDateFormat;
import java.util.Map;

/**
 * The Class VitriaPreparer.
 */
public class VitriaPreparer extends Preparer implements ReportPreparer {

    /** The Constant SORT_BY_CLAIM_INDEX. */
    private static final int SORT_BY_CLAIM_INDEX = 1;

    /** The Constant SORT_BY_LINE_SEQ. */
    private static final int SORT_BY_LINE_SEQ = 2;

    /** The Constant SORT_BY_DATE. */
    private static final int SORT_BY_DATE = 0;

    /**
     * {@inheritDoc}
     */
    @Override
    @SuppressWarnings("unchecked")
    public final void prepare(final SearchCriteriaRequest c) {
        Map params = getParams();

        prepareVitriaDateRangeParam(c);
        prepareLimitRowParam(c);
        prepareVitriaOrderByParam(c);
        prepareProjectClause(c);
        prepareFacilities(c);

        String serviceCodes = ItemUtil.concatItemsNoPars(c.getServiceCodes());
        params.put("service_codes", serviceCodes);

        String transCodes = ItemUtil.concatItemsNoPars(c.getTransCodes());
        params.put("transaction_codes", transCodes);

        params.put("limit_rows", c.getNumResults());
    }

    /**
     * Prepare date range param.
     *
     * @param c the c
     */
    @SuppressWarnings("unchecked")
    private void prepareVitriaDateRangeParam(final SearchCriteriaRequest c) {
        Map params = getParams();
        DateValue dv = c.getDateValue();
        String startDate = new SimpleDateFormat("MM/dd/yyyy").format(dv
                .getFromDate());
        String endDate = new SimpleDateFormat("MM/dd/yyyy").format(dv
                .getToDate());
        params.put("date_type", dv.getDateType());
        params.put("start_date", startDate);
        params.put("end_date", endDate);
        if ("R".equals(dv.getDateType())) {
            params.put("date_field", "fcp.date_created");
        } else {
            params.put("date_field", "fcp.date_modified");
        }
    }

    /**
     * Prepares order clause for this reports.
     *
     * @param c the criteria
     */
    @SuppressWarnings("unchecked")
    private void prepareVitriaOrderByParam(final SearchCriteriaRequest c) {
        Map params = getParams();
        String orderBy;
        switch (c.getSortBy()) {
        case SORT_BY_CLAIM_INDEX:
            orderBy = "cl.claim_index, fcpl.line_item_sequence";
            break;
        case SORT_BY_LINE_SEQ:
            orderBy = "fcpl.line_item_sequence, cl.claim_index";
            break;
        case SORT_BY_DATE:
            if ("R".equals(c.getDateValue().getDateType())) {
                orderBy = "fcp.date_created";
            } else {
                orderBy = "fcp.date_modified";
            }
            break;
        default:
            orderBy = "cl.claim_index, fcpl.line_item_sequence";
        }
        params.put("order_by", orderBy);
    }

    /**
    * {@inheritDoc}
    */
    public final String getTemplateName() {
        return "Vitria";
    }
}
