/*
 * $Id: ReportPreparer.java,v 1.4 2009/07/31 22:03:58 vhahacnguyes Exp $
 */
package gov.va.med.fee.report.jasper;

import java.util.Map;

import gov.va.med.fee.model.request.SearchCriteriaRequest;

/**
 * The Interface ReportPreparer.
 */
public interface ReportPreparer {

    /**
     * Prepare the parameters based on user selections before sending to
     * report generator.
     *
     * @param c the c
     */
    void prepare(SearchCriteriaRequest c);

    /**
     * Gets the template name (.jrxml file) for a specific report.
     *
     * @return the template name
     */
    String getTemplateName();

    /**
     * Gets the params.
     *
     * @return the params
     */
    Map<String, Object> getParams();

}
