/*
 * $Id: ReportPrepFactory.java,v 1.4 2009/07/21 20:13:56 vhahacnguyes Exp $
 */
package gov.va.med.fee.report.jasper;

import gov.va.med.fee.model.request.SearchCriteriaRequest;
import gov.va.med.fee.report.ReportNumber;
import gov.va.med.fee.report.ReportNumber.ReportTemplate;

/**
 * Report preparer factory.
 */
public final class ReportPrepFactory {
    /**
    * Gets the report preparer based on selection criteria.
    *
    * @param c
    *            the criteria
    * @return the report preparer
    */
    public ReportPreparer getPreparer(final SearchCriteriaRequest c) {
        ReportPreparer prep = null;
        ReportTemplate rep = new ReportNumber().decodeRep(c.getReport());

        switch (rep) {
        case AGING:
            prep = new AgingPreparer();
            break;
        case AGING_SUMMARY:
            prep = new AgingSumPreparer();
            break;
        case OUT_OF_SYS:
            prep = new OutOfSysPreparer();
            break;
        case OUT_OF_SYS_SUMMARY:
            prep = new OutOfSysSumPreparer();
            break;
        case RE_ROUTED:
            //prep = new ReroutedPreparer();
            break;
        case VITRIA:
            prep = new VitriaPreparer();
            break;
        default:
            return null;
        }

        prep.prepare(c);
        return prep;
    }
}
