package gov.va.med.fee.report.jasper;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;


import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.export.SimpleCsvExporterConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimpleWriterExporterOutput;
import net.sf.jasperreports.export.SimpleXlsReportConfiguration;


/*import org.jboss.seam.Component;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage.Severity;
import org.jboss.seam.log.Log;
import org.jboss.seam.log.Logging;*/

/**
 * Generates report using Jasper Report.
 */

public class ReportGenerator {

	private static final Logger logger = LogManager.getLogger(ReportGenerator.class);

     /**
     * Instantiates a new report generator.
     */
    
	public ReportGenerator() {
    }

    /**
     * Prints report in PDF format.
     *
     * @param params the params
     * @param template the template
     * @param attachmentName the attachment name
     *
     * @return true, if prints the report
     * @throws SQLException 
     */
    public ByteArrayOutputStream printReport(Map<String, Object> params, String template, String attachmentName, Connection connection) throws SQLException {
        return printReport("P", params, template, attachmentName, connection);
    }

    /**
     * Prints report in specified format. P=PDF, H=HTML, C=CSV, E=Excel
     *
     * @param format the format(P=PDF, C=CSV, E=Excel)
     * @param params the params
     * @param template the template(a .jrxml file to call)
     * @param attachmentName the attachment name
     *
     * @return true, if prints the report
     * @throws SQLException 
     */
    public ByteArrayOutputStream printReport(String format, Map<String, Object> params,
            String template, String attachmentName, Connection connection) throws SQLException {

    	ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
         
    	try {
            //FacesContext context = FacesContext.getCurrentInstance();
            //ExternalContext ext = context.getExternalContext();
    		InputStream fis = this.getClass().getResourceAsStream(template);              
			JasperReport jasperReport = JasperCompileManager.compileReport(fis);
            
            if ("P".equalsIgnoreCase(format)) {
                params.put(JRParameter.IS_IGNORE_PAGINATION, Boolean.FALSE);
                JasperPrint jasperPrint = JasperFillManager.fillReport(jasperReport, params, connection);
                                
                JasperExportManager.exportReportToPdfStream(jasperPrint, outputStream);

            } else if ("C".equalsIgnoreCase(format)) {
                params.put(JRParameter.IS_IGNORE_PAGINATION, Boolean.TRUE);
                JasperPrint jasperPrint = JasperFillManager.fillReport(jasperReport, params, connection);
                
                JRCsvExporter exporter = new JRCsvExporter();               
                exporter.setExporterInput(new SimpleExporterInput(jasperPrint));
                
                SimpleWriterExporterOutput exporterOutput = new SimpleWriterExporterOutput(outputStream);
                exporter.setExporterOutput(exporterOutput);                
                
                //ReportExportConfiguration.PROPERTY_IGNORE_PAGE_MARGINS
                SimpleCsvExporterConfiguration configuration = new SimpleCsvExporterConfiguration();
                configuration.setWriteBOM(Boolean.TRUE);

                configuration.setRecordDelimiter("\r\n");
                exporter.setConfiguration(configuration);
                exporter.exportReport();
                
                /*
                HttpServletResponse resp = (HttpServletResponse) ext.getResponse();

                resp.setContentType("text/plain");
                String filename = new StringBuffer(attachmentName).append(
                        ".csv").toString();
                resp.setHeader("Content-Disposition", "inline;filename="
                        + filename);

                JRCsvExporter exporter = new JRCsvExporter();
                exporter.setParameter(JRCsvExporterParameter.JASPER_PRINT, jasperPrint);
                exporter.setParameter(JRCsvExporterParameter.OUTPUT_STREAM, resp.getOutputStream());
                exporter.setParameter(JRExporterParameter.IGNORE_PAGE_MARGINS, Boolean.TRUE);
                //exporter.setParameter(JRParameter.IS_IGNORE_PAGINATION, Boolean.TRUE);
                exporter.exportReport();*/
            }/* else if ("E".equalsIgnoreCase(format)) {
                JasperPrint jasperPrint = JasperFillManager.fillReport(jasperReport, params, connection);
                
                //HttpServletResponse resp = (HttpServletResponse) ext.getResponse();
                //resp.setContentType("application/vnd.ms-excel");
                //String filename = new StringBuffer(attachmentName).append(".xls").toString();
                //resp.setHeader("Content-Disposition", "inline;filename=" + filename);
                
                JRXlsExporter exporter = new JRXlsExporter();
                exporter.setExporterInput(new SimpleExporterInput(jasperPrint));
                
                SimpleOutputStreamExporterOutput exporterOutput = new SimpleOutputStreamExporterOutput(outputStream);
                exporter.setExporterOutput(exporterOutput); 
                
                SimpleXlsReportConfiguration configuration = new SimpleXlsReportConfiguration();
                configuration.setDetectCellType(true);
                configuration.setWhitePageBackground(false);
                configuration.setRemoveEmptySpaceBetweenRows(true);
                configuration.setRemoveEmptySpaceBetweenColumns(true);
                configuration.setIgnoreCellBorder(true);
                configuration.setCollapseRowSpan(false);
                exporter.setConfiguration(configuration);
                
                JExcelApiExporter exporterXLS = new JExcelApiExporter();

                //exporterXLS.setParameter(JRXlsExporterParameter.JASPER_PRINT, jasperPrint);
                //exporterXLS.setParameter(JRXlsExporterParameter.IS_DETECT_CELL_TYPE, Boolean.TRUE);
                //exporterXLS.setParameter(JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND, Boolean.FALSE);
                //exporterXLS.setParameter(JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, Boolean.TRUE);
                //exporterXLS.setParameter( JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_COLUMNS,Boolean.TRUE);
                //exporterXLS.setParameter( JRXlsExporterParameter.IS_IGNORE_CELL_BORDER, Boolean.TRUE);
                //exporterXLS.setParameter(JRXlsExporterParameter.OUTPUT_STREAM, resp.getOutputStream());
                
                exporter.exportReport();
            }*/

            /*context.getApplication().getStateManager().saveView(context);
            context.responseComplete();*/

           // return true;
        } catch (Exception e) {
            logger.error(e);
            
        } finally {
            try {
            	connection.close();
            } catch (Exception e) {
            	logger.error(e);
            }
        }
    	
        return outputStream;
    }
}
