/*
 * $Id: Preparer.java,v 1.11 2010/01/07 14:50:31 vhahacnguyes Exp $
 */
package gov.va.med.fee.report.jasper;

import gov.va.med.fee.model.request.SearchCriteriaRequest;
import gov.va.med.fee.report.DateValue;
import gov.va.med.fee.report.ReportNumber;
import gov.va.med.fee.report.util.ItemUtil;
//import gov.va.med.fee.sec.HomePageUserData;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

//import org.jboss.seam.Component;

/**
 * The Class Preparer.
 */
public abstract class Preparer implements ReportPreparer {

    /** The Constant SORT_BY_CLAIM_INDEX. */
    private static final int SORT_BY_CLAIM_INDEX = 1;

    /** The Constant SORT_BY_NAME. */
    private static final int SORT_BY_NAME = 2;

    /** The Constant SORT_BY_DATE. */
    private static final int SORT_BY_DATE = 0;

    /** The Constant ALL_PROJECTS. */
    private static final int ALL_PROJECTS = 0;

    /** The Constant HERO_ONLY. */
    private static final int HERO_ONLY = 1;

    /** The Constant NON_HERO. */
    private static final int NON_HERO = 2;

    /** The Constant DATE_FORMAT. */
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");

    /** The params. */
    @SuppressWarnings("unchecked")
    private final Map params = new HashMap();

    /**
    * {@inheritDoc}
    */
    @SuppressWarnings("unchecked")
    public final Map getParams() {
        return params;
    }

    /**
     * Does nothing.
     *
     * @param c the c
     */
    public void prepare(final SearchCriteriaRequest c) {
    }

    /**
     * Prepare service type param.
     *
     * @param c the c
     */
    @SuppressWarnings("unchecked")
    protected final void prepareServiceTypeParam(final SearchCriteriaRequest c) {
        String serviceTypes = ItemUtil.concatItemsNoPars(c.getReportTypes());
        params.put("service_types", serviceTypes);
    }

    /**
     * Prepare claim status.
     *
     * @param c the c
     */
    @SuppressWarnings("unchecked")
    protected final void prepareClaimStatus(final SearchCriteriaRequest c) {
        String claimStatus = new ReportNumber()
            .getClaimStatus(c.getReportNumber());
        params.put("claim_status", claimStatus);
    }

    /**
     * Prepare date range param.
     *
     * @param c the c
     */
    @SuppressWarnings("unchecked")
    protected final void prepareDateRangeParam(final SearchCriteriaRequest c) {
        DateValue dv = c.getDateValue();
        String startDate = DATE_FORMAT.format(rollBackToBeginningOfDay(dv.getFromDate()));
        String endDate = DATE_FORMAT.format(forwardToEndOfDay(dv.getToDate()));
        params.put("date_type", dv.getDateType());
        params.put("start_date", startDate);
        params.put("end_date", endDate);
        if ("R".equals(dv.getDateType())) {
            params.put("date_field", "cl.date_created");
        } else {
            params.put("date_field", "cl.date_modified");
        }
    }

    /**
     * Roll back to beginning of day.
     *
     * @param dt the dt
     *
     * @return the date
     */
    private Date rollBackToBeginningOfDay(Date dt) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        cal.set(Calendar.HOUR, 0);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.MILLISECOND, 0);
        cal.set(Calendar.AM_PM, Calendar.AM);
        return cal.getTime();
    }

    /**
     * Forward to end of day.
     *
     * @param dt the dt
     *
     * @return the date
     */
    private Date forwardToEndOfDay(Date dt) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(rollBackToBeginningOfDay(dt));
        cal.add(Calendar.HOUR, 23);
        cal.add(Calendar.MINUTE, 59);
        cal.add(Calendar.SECOND, 59);
        cal.add(Calendar.MILLISECOND, 999);
        return cal.getTime();
    }

    /**
     * Prepare limit row param.
     *
     * @param c the c
     */
    @SuppressWarnings("unchecked")
    protected final void prepareLimitRowParam(final SearchCriteriaRequest c) {
        params.put("limit_rows", c.getNumResults());
    }

    /**
     * Prepare order by param.
     *
     * @param c the c
     */
    @SuppressWarnings("unchecked")
    protected final void prepareOrderByParam(final SearchCriteriaRequest c) {
        String orderBy;
        switch(c.getSortBy()) {
        case SORT_BY_CLAIM_INDEX:
            orderBy = "cl.claim_index";
            break;
        case SORT_BY_NAME:
            orderBy = "cl.patient_name";
            break;
        case SORT_BY_DATE:
            if ("R".equals(c.getDateValue().getDateType())) {
                orderBy = "cl.date_created";
            } else {
                orderBy = "cl.date_modified";
            }
            break;
        default:
            orderBy = "cl.claim_index";
        }

        params.put("order_by", orderBy);
    }

    /**
     * Prepare project condition.
     *
     * @param c the c
     */
    @SuppressWarnings("unchecked")
    protected final void prepareProjectClause(final SearchCriteriaRequest c) {
        switch(c.getProject()) {
        case HERO_ONLY:
            params.put("hero_flag", "and cl.hero_flag='Y'");
            break;
        case NON_HERO:
            params.put("hero_flag", "and cl.hero_flag='N'");
            break;
        case ALL_PROJECTS:
        default:
            params.put("hero_flag", "");
        }
    }

    /**
     * Prepares facilities including visn claims.
     *
     * @param c the c
     */
    @SuppressWarnings("unchecked")
    protected final void prepareFacilities(final SearchCriteriaRequest c) {
        String facilities = ItemUtil.concatItemsNoPars(c.getFacilities());
        params.put("facility_codes", facilities);

        String visnClaims = "";
        if (c.getVisnClaims() != 0) {
            //HomePageUserData homePageUserData = (HomePageUserData) Component.getInstance("homePageUserData");
            String roles = "ADMIN"; //homePageUserData.getActiveRolesStr();
            if (roles != null) {
                if (roles.indexOf("ADMIN") != -1) {
                    visnClaims = "or cl.va_facility_cd is null";
                } else if (roles.indexOf("ADMIN") == -1 && roles.indexOf("FEE VISN PGM MANAGER") != -1) {
                    visnClaims = "or (cl.va_facility_cd is null and cl.visn_id_cd in " +
                            "(select distinct(f.visn_id_cd) from fpps_owner.va_facility f " +
                            "where f.va_facility_cd in ( " +
                            facilities +
                            ")))";
                }
            }
         }
         params.put("visn_claims", visnClaims);
    }

}
