/*
 * $Id: OutOfSysPreparer.java,v 1.7 2010/01/07 14:50:31 vhahacnguyes Exp $
 */
package gov.va.med.fee.report.jasper;

import java.util.Map;

import gov.va.med.fee.model.request.SearchCriteriaRequest;

/**
 * Prepares parameters for the Out of System Payment report.
 */
public final class OutOfSysPreparer extends Preparer {

    /**
    * {@inheritDoc}
    */
    public String getTemplateName() {
        return "OutOfSys";
    }

    /**
    * {@inheritDoc}
    */
    @Override
    @SuppressWarnings("unchecked")
    public void prepare(final SearchCriteriaRequest c) {
        Map params = getParams();

        prepareServiceTypeParam(c);
        prepareDateRangeParam(c);
        prepareLimitRowParam(c);
        prepareOrderByParam(c);
        prepareProjectClause(c);
        prepareFacilities(c);
    }
}
