/*
 * $Id: AgingPreparer.java,v 1.8 2010/01/07 14:50:31 vhahacnguyes Exp $
 */
package gov.va.med.fee.report.jasper;

import java.util.Map;

import gov.va.med.fee.model.request.SearchCriteriaRequest;

/**
 * The Class AgingPreparer.
 */
public final class AgingPreparer extends Preparer {

    /**
    * {@inheritDoc}
    */
    @Override
    @SuppressWarnings("unchecked")
    public void prepare(final SearchCriteriaRequest c) {
        Map params = getParams();

        prepareServiceTypeParam(c);
        prepareDateRangeParam(c);
        prepareClaimStatus(c);
        prepareOrderByParam(c);
        prepareProjectClause(c);
        prepareFacilities(c);

        params.put("limit_rows", c.getNumResults());
    }

    /**
    * {@inheritDoc}
    */
    @Override
    public String getTemplateName() {
        return "Aging";
    }
}
