/*
 * $Id: ReportNumber.java,v 1.6 2009/09/21 17:48:13 vhahacnguyes Exp $
 */
package gov.va.med.fee.report;

/**
 * The Class ReportNumber.
 */
public class ReportNumber {

    /** The Constant COMPLETED. */
    public static final int COMPLETED = 1;

    /** The Constant COMPLETED_SUM. */
    public static final int COMPLETED_SUM = 2;

    /** The Constant IN_PROCESS. */
    public static final int IN_PROCESS = 3;

    /** The Constant IN_PROCESS_SUM. */
    public static final int IN_PROCESS_SUM = 4;

    /** The Constant AWAITING. */
    public static final int AWAITING = 5;

    /** The Constant AWAITING_SUM. */
    public static final int AWAITING_SUM = 6;

    /** The Constant OUT_OF_SYSTEM_SUM. */
    public static final int OUT_OF_SYSTEM_SUM = 7;

    /** The Constant REROUTED. */
    public static final int REROUTED = 8;

    /** The Constant VISTA. */
    public static final int VISTA = 9;

    /** The Constant OUT_OF_SYSTEM_DETAILED. */
    public static final int OUT_OF_SYSTEM_DETAILED = 10;

    /**
    * Enumerations of reports that we support.
    */
    public static enum ReportTemplate {

        /** The AGING. */
        AGING,

        /** The aging summary. */
        AGING_SUMMARY,

        /** The out of sys. */
        OUT_OF_SYS,

        /** The out of sys summary. */
        OUT_OF_SYS_SUMMARY,

        /** The rerouted. */
        RE_ROUTED,

        /** The VITRIA. */
        VITRIA,

        /** The UNDEFINED. */
        UNDEFINED
    }

    /**
    * Gets the claim status.
    *
    * @param reportNumber
    *            the report number
    *
    * @return the claim status
    */
    public final String getClaimStatus(final int reportNumber) {
        switch (reportNumber) {
        case ReportNumber.COMPLETED:
            return "COMPLETE";
        case ReportNumber.COMPLETED_SUM:
            return "COMPLETE";
        case ReportNumber.IN_PROCESS:
            return "INPROCESS";
        case ReportNumber.IN_PROCESS_SUM:
            return "INPROCESS";
        case ReportNumber.AWAITING:
            return "ESTABLISH";
        case ReportNumber.AWAITING_SUM:
            return "ESTABLISH";
        default:
            return "";
        }
    }

    /**
    * Maps from the given report number to a report template.
    *
    * @param reportNum
    *            the report num
    *
    * @return the report template
    */
    public final ReportTemplate decodeRep(final String reportNum) {
        int i = Integer.parseInt(reportNum);
        switch (i) {
        case COMPLETED:
            return ReportTemplate.AGING;
        case COMPLETED_SUM:
            return ReportTemplate.AGING_SUMMARY;
        case IN_PROCESS:
            return ReportTemplate.AGING;
        case IN_PROCESS_SUM:
            return ReportTemplate.AGING_SUMMARY;
        case AWAITING:
            return ReportTemplate.AGING;
        case AWAITING_SUM:
            return ReportTemplate.AGING_SUMMARY;
        case OUT_OF_SYSTEM_SUM:
            return ReportTemplate.OUT_OF_SYS_SUMMARY;
        case REROUTED:
            return ReportTemplate.RE_ROUTED;
        case VISTA:
            return ReportTemplate.VITRIA;
        case OUT_OF_SYSTEM_DETAILED:
            return ReportTemplate.OUT_OF_SYS;
        default:
            return ReportTemplate.UNDEFINED;
        }
    }

}
