/*
 * $Id: DateValue.java,v 1.5 2009/07/08 15:07:53 vhahacnguyes Exp $
 */
package gov.va.med.fee.report;

//import static org.jboss.seam.ScopeType.EVENT;
import gov.va.med.fee.report.util.ItemUtil;

import java.util.Calendar;
import java.util.Date;

//import org.hibernate.validator.Min;
//import org.hibernate.validator.Past;


/**
 * The Class DateValue.
 */
//@Name("dateValue")
public class DateValue {

    /**
     * The Enum FieldName.
     */
    public static enum FieldName {

        /** The DAYS. */
        DAYS,

        /** The FROM. */
        FROM,

        /** The TO. */
        TO
    };

    /** The Constant AGE. */
    private static final String AGE = "1";

    /** The Constant RANGE. */
    private static final String RANGE = "2";

    /** The date type. */
    private String dateType;

    /** The days. */
   // @ReportDate(field = FieldName.DAYS)
    //@Min(0)
    private Integer days;

    /** The from date. */
   // @ReportDate(field = FieldName.FROM)
   // @Past
    private Date fromDate;

    /** The to date. */
    //@ReportDate(field = FieldName.TO)
   // @Past
    private Date toDate;

    /** The tab type. */
    private String tabType;

    /**
     * Checks if is valid.
     *
     * @return true, if is valid
     */
    public final boolean isValid() {
        boolean status = false;
        if (AGE == tabType) {
            if (days != null) {
                status = true;
            } else {
                status = false;
            }
            setToFromDates(days);
        } else {
            status = isValid(fromDate, toDate);
        }
        return status;
    }

    /**
     * Checks if is valid. FromDate must be before toDate.
     *
     * @param from the from date
     * @param to the to date
     *
     * @return true, if is valid
     */
    public final boolean isValid(final Date from, final Date to) {
        if (from == null || to == null) {
            return false;
        }

        Calendar calFrom = Calendar.getInstance();
        calFrom.setTime(from);

        Calendar calTo = Calendar.getInstance();
        calTo.setTime(to);

        return calTo.after(calFrom) || calTo.equals(calFrom);
    }

    /**
     * Gets the tab type.
     *
     * @return the tab type
     */
    public final String getTabType() {
        return tabType;
    }

    /**
     * Sets the tab type.
     *
     * @param tabType the new tab type
     */
    public final void setTabType(final String tabType) {
        this.tabType = tabType;
    }

    /**
     * Age tab.
     */
    public final void ageTab() {
        tabType = AGE;
    }

    /**
     * Range tab.
     */
    public final void rangeTab() {
        tabType = RANGE;
    }

    /**
     * Sets the to from dates.
     *
     * @param d the new to from dates
     */
    private void setToFromDates(final Integer d) {
        if (d == null) {
            return;
        }

        Calendar cal = java.util.Calendar.getInstance();
        setToDate(cal.getTime());
        cal.add(Calendar.DATE, 0 - d);
        setFromDate(cal.getTime());
    }

    /**
     * Reset.
     */
    public final void reset() {
        dateType = "R";
        tabType = AGE;
        days = null;
        fromDate = null;
        toDate = null;
    }

    /**
     * Checks if is received date.
     *
     * @return true, if is received date
     */
    public final boolean isReceivedDate() {
        return "R".equals(dateType) ? true : false;
    }

    /**
     * Getter for property dateType.
     *
     * @return Value of property dateType.
     */
    public final String getDateType() {
        return this.dateType;
    }

    /**
     * Setter for property dateType.
     *
     * @param dateType New value of property dateType.
     */
    public final void setDateType(final String dateType) {
        this.dateType = dateType;
    }

    /**
     * Setter for property fromDate.
     *
     * @param fromDate New value of property fromDate.
     */
    public final void setFromDate(final Date fromDate) {
        this.fromDate = fromDate;
    }

    /**
     * Getter for property fromDate.
     *
     * @return Value of property fromDate.
     */
    public final Date getFromDate() {
        return this.fromDate;
    }

    /**
     * Getter for property fromDate.
     *
     * @return Value of property fromDate.
     */
    public final String getFromDateStr() {
        return ItemUtil.formatPLSQLDate(fromDate);
    }

    /**
     * Getter for property toDate.
     *
     * @return Value of property toDate.
     */
    public final Date getToDate() {
        return this.toDate;
    }

    /**
     * Setter for property toDate.
     *
     * @param toDate New value of property toDate.
     */
    public final void setToDate(final Date toDate) {
        this.toDate = toDate;
    }

    /**
     * Getter for property toDate.
     *
     * @return Value of property toDate.
     */
    public final String getToDateStr() {
        return ItemUtil.formatPLSQLDate(toDate);
    }

    /**
     * Gets the days.
     *
     * @return the days
     */
    public final Integer getDays() {
        return days;
    }

    /**
     * Sets the days.
     *
     * @param days the new days
     */
    public final void setDays(final Integer days) {
        this.days = days;
    }

}
