/**
 * 
 */
package gov.va.med.fee.model.response;

import java.math.BigDecimal;
import java.util.List;

import gov.va.med.fee.model.request.ContactInfoRequest;
import gov.va.med.fee.model.request.ZipCodeRequest;


/**
 * @author Vamsi Krishna Gangarapu
 *
 */
public class VaFacilityResponse {

	String station;
	String shortName;
	String stationName;
	String stationType;
	String visnNumber;
	boolean allowReroute;
	BigDecimal agedDef;
	String parentStation;
	String createdBy;
	String dateCreated;
	
	private List<ContactInfoRequest> contactInfoRequest;
	private List<ZipCodeRequest> zipcodes;
	
	public VaFacilityResponse() {
		super();
		// TODO Auto-generated constructor stub
	}
	
	public VaFacilityResponse(String station, String shortName, String stationName, String stationType,
			String visnNumber, boolean allowReroute, BigDecimal agedDef, String parentStation, String createdBy,
			String dateCreated) {
		super();
		this.station = station;
		this.shortName = shortName;
		this.stationName = stationName;
		this.stationType = stationType;
		this.visnNumber = visnNumber;
		this.allowReroute = allowReroute;
		this.agedDef = agedDef;
		this.parentStation = parentStation;
		this.createdBy = createdBy;
		this.dateCreated = dateCreated;
	}

	public String getStation() {
		return station;
	}
	public void setStation(String station) {
		this.station = station;
	}
	public String getShortName() {
		return shortName;
	}
	public void setShortName(String shortName) {
		this.shortName = shortName;
	}
	public String getStationName() {
		return stationName;
	}
	public void setStationName(String stationName) {
		this.stationName = stationName;
	}
	public String getStationType() {
		return stationType;
	}
	public void setStationType(String stationType) {
		this.stationType = stationType;
	}
	public String getVisnNumber() {
		return visnNumber;
	}
	public void setVisnNumber(String visnNumber) {
		this.visnNumber = visnNumber;
	}
	public boolean getAllowReroute() {
		return allowReroute;
	}
	public void setAllowReroute(boolean b) {
		this.allowReroute = b;
	}
	public BigDecimal getAgedDef() {
		return agedDef;
	}
	public void setAgedDef(BigDecimal agedDef) {
		this.agedDef = agedDef;
	}
	public String getParentStation() {
		return parentStation;
	}
	public void setParentStation(String parentStation) {
		this.parentStation = parentStation;
	}
	public String getCreatedBy() {
		return createdBy;
	}
	public void setCreatedBy(String createdBy) {
		this.createdBy = createdBy;
	}
	public String getDateCreated() {
		return dateCreated;
	}
	public void setDateCreated(String dateCreated2) {
		this.dateCreated = dateCreated2;
	}
	
	public List<ContactInfoRequest> getContactInfoRequest() {
		return contactInfoRequest;
	}

	public void setContactInfoRequest(List<ContactInfoRequest> contactInfoRequest) {
		this.contactInfoRequest = contactInfoRequest;
	}
			
	public List<ZipCodeRequest> getZipcodes() {
		return zipcodes;
	}

	public void setZipcodes(List<ZipCodeRequest> zipcodes) {
		this.zipcodes = zipcodes;
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("VaFacilityResponse [station=");
		builder.append(station);
		builder.append(", shortName=");
		builder.append(shortName);
		builder.append(", stationName=");
		builder.append(stationName);
		builder.append(", stationType=");
		builder.append(stationType);
		builder.append(", visnNumber=");
		builder.append(visnNumber);
		builder.append(", allowReroute=");
		builder.append(allowReroute);
		builder.append(", agedDef=");
		builder.append(agedDef);
		builder.append(", parentStation=");
		builder.append(parentStation);
		builder.append(", createdBy=");
		builder.append(createdBy);
		builder.append(", dateCreated=");
		builder.append(dateCreated);
		builder.append("]");
		return builder.toString();
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((agedDef == null) ? 0 : agedDef.hashCode());
		result = prime * result + (allowReroute ? 1231 : 1237);
		result = prime * result + ((contactInfoRequest == null) ? 0 : contactInfoRequest.hashCode());
		result = prime * result + ((createdBy == null) ? 0 : createdBy.hashCode());
		result = prime * result + ((dateCreated == null) ? 0 : dateCreated.hashCode());
		result = prime * result + ((parentStation == null) ? 0 : parentStation.hashCode());
		result = prime * result + ((shortName == null) ? 0 : shortName.hashCode());
		result = prime * result + ((station == null) ? 0 : station.hashCode());
		result = prime * result + ((stationName == null) ? 0 : stationName.hashCode());
		result = prime * result + ((stationType == null) ? 0 : stationType.hashCode());
		result = prime * result + ((visnNumber == null) ? 0 : visnNumber.hashCode());
		result = prime * result + ((zipcodes == null) ? 0 : zipcodes.hashCode());
		return result;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		VaFacilityResponse other = (VaFacilityResponse) obj;
		if (agedDef == null) {
			if (other.agedDef != null)
				return false;
		} else if (!agedDef.equals(other.agedDef))
			return false;
		if (allowReroute != other.allowReroute)
			return false;
		if (contactInfoRequest == null) {
			if (other.contactInfoRequest != null)
				return false;
		} else if (!contactInfoRequest.equals(other.contactInfoRequest))
			return false;
		if (createdBy == null) {
			if (other.createdBy != null)
				return false;
		} else if (!createdBy.equals(other.createdBy))
			return false;
		if (dateCreated == null) {
			if (other.dateCreated != null)
				return false;
		} else if (!dateCreated.equals(other.dateCreated))
			return false;
		if (parentStation == null) {
			if (other.parentStation != null)
				return false;
		} else if (!parentStation.equals(other.parentStation))
			return false;
		if (shortName == null) {
			if (other.shortName != null)
				return false;
		} else if (!shortName.equals(other.shortName))
			return false;
		if (station == null) {
			if (other.station != null)
				return false;
		} else if (!station.equals(other.station))
			return false;
		if (stationName == null) {
			if (other.stationName != null)
				return false;
		} else if (!stationName.equals(other.stationName))
			return false;
		if (stationType == null) {
			if (other.stationType != null)
				return false;
		} else if (!stationType.equals(other.stationType))
			return false;
		if (visnNumber == null) {
			if (other.visnNumber != null)
				return false;
		} else if (!visnNumber.equals(other.visnNumber))
			return false;
		if (zipcodes == null) {
			if (other.zipcodes != null)
				return false;
		} else if (!zipcodes.equals(other.zipcodes))
			return false;
		return true;
	}	
}
