package gov.va.med.fee.model.response;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonInclude;


public class UserReqResponse {

	private String window_nt_name;
	private String last_name;
	private String first_name;
	private String middle_name;
	private String phone;
	private String email;
	private Boolean enabled;
	
	private String disable_comments; //Disable Comments
	private List<String> request_roles;  //Request Roles for modify user
	private List<String> request_facilities;  //Request Facilities for modify user
	
	private List<String> available_roles; //Available Roles
	private List<String> available_facilities;  //Available Facilities
	
	public UserReqResponse() {
		super();
	}
	
	//Response for modify user request
	public UserReqResponse(String window_nt_name, String last_name, String first_name, String middle_name,
			String phone, String email, Boolean enabled, String disable_comments, List<String> request_roles, List<String> request_facilities) {
		super();
		this.window_nt_name = window_nt_name;
		this.last_name = last_name;
		this.first_name = first_name;
		this.middle_name = middle_name;
		this.phone = phone;
		this.email = email;
		this.enabled = enabled;
		this.disable_comments = disable_comments;
		this.request_roles = request_roles;
		this.request_facilities = request_facilities;
	}
	
	//Response for loading create user request
	public UserReqResponse(List<String> available_roles, List<String> available_facilities) {
		this.available_roles = available_roles;
		this.available_facilities = available_facilities;
	}
	
	/**
	 * @return the window_nt_name
	 */
	@JsonInclude(JsonInclude.Include.NON_NULL)
	public String getWindow_nt_name() {
		return window_nt_name == null? null : window_nt_name.toUpperCase();
	}

	/**
	 * @param window_nt_name the window_nt_name to set
	 */
	public void setWindow_nt_name(String window_nt_name) {
		this.window_nt_name = window_nt_name;
	}

	/**
	 * @return the last_name
	 */
	@JsonInclude(JsonInclude.Include.NON_NULL)
	public String getLast_name() {
		return last_name == null? null : last_name.toUpperCase();
	}

	/**
	 * @param last_name the last_name to set
	 */
	public void setLast_name(String last_name) {
		this.last_name = last_name;
	}

	/**
	 * @return the first_name
	 */
	@JsonInclude(JsonInclude.Include.NON_NULL)
	public String getFirst_name() {
		return first_name == null? null : first_name.toUpperCase();
	}

	/**
	 * @param first_name the first_name to set
	 */
	public void setFirst_name(String first_name) {
		this.first_name = first_name;
	}

	/**
	 * @return the middle_name
	 */
	@JsonInclude(JsonInclude.Include.NON_NULL)
	public String getMiddle_name() {
		
		return middle_name == null? null : middle_name.toUpperCase();
	}

	/**
	 * @param middle_name the middle_name to set
	 */
	public void setMiddle_name(String middle_name) {
		this.middle_name = middle_name;
	}

	/**
	 * @return the phone
	 */
	@JsonInclude(JsonInclude.Include.NON_NULL)
	public String getPhone() {
		return phone;
	}

	/**
	 * @param phone the phone to set
	 */
	public void setPhone(String phone) {
		this.phone = phone;
	}

	/**
	 * @return the email
	 */
	@JsonInclude(JsonInclude.Include.NON_NULL)
	public String getEmail() {
		return email == null? null : email.toUpperCase();
	}

	/**
	 * @param email the email to set
	 */
	public void setEmail(String email) {
		this.email = email;
	}

	/**
	 * @return the enabled
	 */
	@JsonInclude(JsonInclude.Include.NON_NULL)
	public Boolean getEnabled() {
		return enabled;
	}

	/**
	 * @param enabled the enabled to set
	 */
	public void setEnabled(Boolean enabled) {
		this.enabled = enabled;
	}
	
	/**
	 * @return the disable_comments
	 */
	@JsonInclude(JsonInclude.Include.NON_NULL)
	public String getDisable_comments() {
		return disable_comments == null? null : disable_comments.toUpperCase();
	}

	/**
	 * @param disable_comments the disable_comments to set
	 */
	public void setDisable_comments(String disable_comments) {
		this.disable_comments = disable_comments;
	}
	
	/**
	 * @return the request_roles
	 */
	@JsonInclude(JsonInclude.Include.NON_NULL)
	public List<String> getRequest_roles() {
		return request_roles;
	}

	/**
	 * @param request_roles the request_roles to set
	 */
	public void setRequest_roles(List<String> request_roles) {
		this.request_roles = request_roles;
	}

	/**
	 * @return the request_facilities
	 */
	@JsonInclude(JsonInclude.Include.NON_NULL)
	public List<String> getRequest_facilities() {
		return request_facilities;
	}

	/**
	 * @param request_facilities the request_facilities to set
	 */
	public void setRequest_facilities(List<String> request_facilities) {
		this.request_facilities = request_facilities;
	}

	/**
	 * @return the available_roles
	 */
	@JsonInclude(JsonInclude.Include.NON_NULL)
	public List<String> getAvailable_roles() {
		return this.available_roles;
	}

	/**
	 * @param available_roles the available_roles to set
	 */
	public void setAvailable_roles(List<String> available_roles) {
		this.available_roles = available_roles;
	}

	/**
	 * @return the available_facilities
	 */
	@JsonInclude(JsonInclude.Include.NON_NULL)
	public List<String> getAvailable_facilities() {
		return available_facilities;
	}

	/**
	 * @param available_facilities the available_facilities to set
	 */
	public void setAvailable_facilities(List<String> available_facilities) {
		this.available_facilities = available_facilities;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((disable_comments == null) ? 0 : disable_comments.hashCode());
		result = prime * result + ((email == null) ? 0 : email.hashCode());
		result = prime * result + (enabled ? 1231 : 1237);
		result = prime * result + ((first_name == null) ? 0 : first_name.hashCode());
		result = prime * result + ((last_name == null) ? 0 : last_name.hashCode());
		result = prime * result + ((middle_name == null) ? 0 : middle_name.hashCode());
		result = prime * result + ((phone == null) ? 0 : phone.hashCode());
		result = prime * result + ((request_facilities == null) ? 0 : request_facilities.hashCode());
		result = prime * result + ((request_roles == null) ? 0 : request_roles.hashCode());
		result = prime * result + ((window_nt_name == null) ? 0 : window_nt_name.hashCode());
		return result;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		UserReqResponse other = (UserReqResponse) obj;
		if (disable_comments == null) {
			if (other.disable_comments != null)
				return false;
		} else if (!disable_comments.equals(other.disable_comments))
			return false;
		if (email == null) {
			if (other.email != null)
				return false;
		} else if (!email.equals(other.email))
			return false;
		if (enabled != other.enabled)
			return false;
		if (first_name == null) {
			if (other.first_name != null)
				return false;
		} else if (!first_name.equals(other.first_name))
			return false;
		if (last_name == null) {
			if (other.last_name != null)
				return false;
		} else if (!last_name.equals(other.last_name))
			return false;
		if (middle_name == null) {
			if (other.middle_name != null)
				return false;
		} else if (!middle_name.equals(other.middle_name))
			return false;
		if (phone == null) {
			if (other.phone != null)
				return false;
		} else if (!phone.equals(other.phone))
			return false;
		if (request_facilities == null) {
			if (other.request_facilities != null)
				return false;
		} else if (!request_facilities.equals(other.request_facilities))
			return false;
		if (request_roles == null) {
			if (other.request_roles != null)
				return false;
		} else if (!request_roles.equals(other.request_roles))
			return false;
		if (window_nt_name == null) {
			if (other.window_nt_name != null)
				return false;
		} else if (!window_nt_name.equals(other.window_nt_name))
			return false;
		return true;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "window_nt_name=" + window_nt_name
				+ ", last_name=" + last_name + ", first_name=" + first_name + ", middle_name=" + middle_name
				+ ", phone=" + phone + ", email=" + email + ", enabled=" + enabled + ", disable_comments="
				+ disable_comments + ", request_roles=" + request_roles + ", request_facilities="
				+ request_facilities + ", available_roles=" + available_roles + ", available_facilities="
				+ available_facilities;
	}	
}
