package gov.va.med.fee.model.response;

import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonInclude;


public class RerouteClaimResponse {

	@JsonInclude(JsonInclude.Include.NON_NULL)
	private List<RerouteClaimInfo> claims_to_be_rerouted;
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private List<RerouteClaimInfo> denied_reroutes;
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private List<Long> visns;
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private List<String> facilities;
	/*@JsonInclude(JsonInclude.Include.NON_NULL)
	private List<String> names;*/
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private Map<String, String> reasons;
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private String nonRouted; //nonRoutableStr
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private String printedClaimsStr;
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private String comment;
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private Map<Long, List<ReRoutingHistory>> reroute_history;

	@JsonInclude(JsonInclude.Include.NON_NULL)
	private List<String> errorMessages;
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private String reroutedSuccessful;
	
		
	public RerouteClaimResponse() {
		super();
	}

	public RerouteClaimResponse(List<RerouteClaimInfo> claims_to_be_rerouted, List<Long> visns,
			List<String> facilities, Map<String, String> reasons, String nonRouted,
			String printedClaimsStr, String comment, Map<Long, List<ReRoutingHistory>> reroute_history) {
		super();
		this.claims_to_be_rerouted = claims_to_be_rerouted;
		this.visns = visns;
		this.facilities = facilities;
		this.reasons = reasons;
		this.nonRouted = nonRouted;
		this.printedClaimsStr = printedClaimsStr;
		this.comment = comment;
		this.reroute_history = reroute_history;
	}

	
	/**
	 * @return the claims_to_be_rerouted
	 */
	public List<RerouteClaimInfo> getClaims_to_be_rerouted() {
		return claims_to_be_rerouted;
	}

	/**
	 * @param claims_to_be_rerouted the claims_to_be_rerouted to set
	 */
	public void setClaims_to_be_rerouted(List<RerouteClaimInfo> claims_to_be_rerouted) {
		this.claims_to_be_rerouted = claims_to_be_rerouted;
	}
		
	/**
	 * @return the denied_reroutes
	 */
	public List<RerouteClaimInfo> getDenied_reroutes() {
		return denied_reroutes;
	}

	/**
	 * @param denied_reroutes the denied_reroutes to set
	 */
	public void setDenied_reroutes(List<RerouteClaimInfo> denied_reroutes) {
		this.denied_reroutes = denied_reroutes;
	}

	/**
	 * @return the visns
	 */
	public List<Long> getVisns() {
		return visns;
	}

	/**
	 * @param visns the visns to set
	 */
	public void setVisns(List<Long> visns) {
		this.visns = visns;
	}

	/**
	 * @return the facilities
	 */
	public List<String> getFacilities() {
		return facilities;
	}

	/**
	 * @param facilities the facilities to set
	 */
	public void setFacilities(List<String> facilities) {
		this.facilities = facilities;
	}
		
	/**
	 * @return the reasons
	 */
	public Map<String, String> getReasons() {
		return reasons;
	}

	/**
	 * @param reasons the reasons to set
	 */
	public void setReasons(Map<String, String> reasons) {
		this.reasons = reasons;
	}

	/**
	 * @return the nonRouted
	 */
	public String getNonRouted() {
		return nonRouted;
	}

	/**
	 * @param nonRouted the nonRouted to set
	 */
	public void setNonRouted(String nonRouted) {
		this.nonRouted = nonRouted;
	}

	/**
	 * @return the printedClaimsStr
	 */
	public String getPrintedClaimsStr() {
		return printedClaimsStr;
	}

	/**
	 * @param printedClaimsStr the printedClaimsStr to set
	 */
	public void setPrintedClaimsStr(String printedClaimsStr) {
		this.printedClaimsStr = printedClaimsStr;
	}

	/**
	 * @return the comment
	 */
	public String getComment() {
		return comment;
	}

	/**
	 * @param comment the comment to set
	 */
	public void setComment(String comment) {
		this.comment = comment;
	}

	/**
	 * @return the reroute_history
	 */
	public Map<Long, List<ReRoutingHistory>> getReroute_history() {
		return reroute_history;
	}

	/**
	 * @param reroute_history the reroute_history to set
	 */
	public void setReroute_history(Map<Long, List<ReRoutingHistory>> reroute_history) {
		this.reroute_history = reroute_history;
	}
		

	/**
	 * @return the errorMessages
	 */
	public List<String> getErrorMessages() {
		return errorMessages;
	}

	/**
	 * @param errorMessages the errorMessages to set
	 */
	public void setErrorMessages(List<String> errorMessages) {
		this.errorMessages = errorMessages;
	}

	/**
	 * @return the reroutedSuccessful
	 */
	public String getReroutedSuccessful() {
		return reroutedSuccessful;
	}

	/**
	 * @param reroutedSuccessful the reroutedSuccessful to set
	 */
	public void setReroutedSuccessful(String reroutedSuccessful) {
		this.reroutedSuccessful = reroutedSuccessful;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((claims_to_be_rerouted == null) ? 0 : claims_to_be_rerouted.hashCode());
		result = prime * result + ((comment == null) ? 0 : comment.hashCode());
		result = prime * result + ((denied_reroutes == null) ? 0 : denied_reroutes.hashCode());
		result = prime * result + ((errorMessages == null) ? 0 : errorMessages.hashCode());
		result = prime * result + ((facilities == null) ? 0 : facilities.hashCode());
		result = prime * result + ((nonRouted == null) ? 0 : nonRouted.hashCode());
		result = prime * result + ((printedClaimsStr == null) ? 0 : printedClaimsStr.hashCode());
		result = prime * result + ((reasons == null) ? 0 : reasons.hashCode());
		result = prime * result + ((reroute_history == null) ? 0 : reroute_history.hashCode());
		result = prime * result + ((reroutedSuccessful == null) ? 0 : reroutedSuccessful.hashCode());
		result = prime * result + ((visns == null) ? 0 : visns.hashCode());
		return result;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		RerouteClaimResponse other = (RerouteClaimResponse) obj;
		if (claims_to_be_rerouted == null) {
			if (other.claims_to_be_rerouted != null)
				return false;
		} else if (!claims_to_be_rerouted.equals(other.claims_to_be_rerouted))
			return false;
		if (comment == null) {
			if (other.comment != null)
				return false;
		} else if (!comment.equals(other.comment))
			return false;
		if (denied_reroutes == null) {
			if (other.denied_reroutes != null)
				return false;
		} else if (!denied_reroutes.equals(other.denied_reroutes))
			return false;
		if (errorMessages == null) {
			if (other.errorMessages != null)
				return false;
		} else if (!errorMessages.equals(other.errorMessages))
			return false;
		if (facilities == null) {
			if (other.facilities != null)
				return false;
		} else if (!facilities.equals(other.facilities))
			return false;
		if (nonRouted == null) {
			if (other.nonRouted != null)
				return false;
		} else if (!nonRouted.equals(other.nonRouted))
			return false;
		if (printedClaimsStr == null) {
			if (other.printedClaimsStr != null)
				return false;
		} else if (!printedClaimsStr.equals(other.printedClaimsStr))
			return false;
		if (reasons == null) {
			if (other.reasons != null)
				return false;
		} else if (!reasons.equals(other.reasons))
			return false;
		if (reroute_history == null) {
			if (other.reroute_history != null)
				return false;
		} else if (!reroute_history.equals(other.reroute_history))
			return false;
		if (reroutedSuccessful == null) {
			if (other.reroutedSuccessful != null)
				return false;
		} else if (!reroutedSuccessful.equals(other.reroutedSuccessful))
			return false;
		if (visns == null) {
			if (other.visns != null)
				return false;
		} else if (!visns.equals(other.visns))
			return false;
		return true;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "RerouteClaimResponse [claims_to_be_rerouted=" + claims_to_be_rerouted + ", denied_reroutes="
				+ denied_reroutes + ", visns=" + visns + ", facilities=" + facilities + ", reasons=" + reasons
				+ ", nonRouted=" + nonRouted + ", printedClaimsStr=" + printedClaimsStr + ", comment=" + comment
				+ ", reroute_history=" + reroute_history + ", errorMessages=" + errorMessages + ", reroutedSuccessful="
				+ reroutedSuccessful + "]";
	}	
	
}
