package gov.va.med.fee.model.response;

import com.fasterxml.jackson.annotation.JsonInclude;


public class LineItemResponse {

	private Long line_id;
	private Long claimProcId;
	private String tooth_code; //'DENT'
	private String tooth_surface; //'DENT'
	private String tooth_surface_cd_2; //'DENT'
	private String tooth_surface_cd_3; //'DENT'
	private String tooth_surface_cd_4; //'DENT'
	private String tooth_surface_cd_5; //'DENT'
	private String oral_cavity_cd;  //?
	private String medical_code;
	private String revenue_code;  //'INST'
	private String description; //'PROF'
	private String diagnosis_pointers; //'PROF'
	private String service_from_date;
	private String service_to_date;
	private String billed_amount;
	private Long billed_units; //'PROF'
	private String modifier_1; //'PROF'
	private String modifier_2;   //'PROF'
	private String modifier_3;   //'PROF'
	private String modifier_4;  //'PROF'
	private String line_status;
	private String treasury_payment_date;
	private String paid_amount = "";
	private String check_eft_trn = "";
	private String adjustment_amount = "";
	private String group_code="";
	private String reason_code = "";
	private String remittance_remark_code="";
	
		
	public LineItemResponse() {
		super();
	}
	
	public LineItemResponse(Long claimProcedureSeq, String toothCode, String toothSurface, String toothSurfaceCd2,
			String toothSurfaceCd3, String toothSurfaceCd4, String toothSurfaceCd5, String procCode, String revenueCode,
			String procCodeDesc, String diagPointer, String serviceFromDate, String serviceToDate,
			String billedAmount, Long billedUnits, String modifier1, String modifier2, String modifier3,
			String modifier4, String lineStatus, String lineItemTreasuryPaymentDateFormatted,
			String lineItemPaidAmountFormatted, String lineItemCheckNumber, String lineItemAdjAmts,
			String lineItemCodes, String lineItemCagcCodes, String lineItemRarcCodes) {
		
		super();
		this.line_id = claimProcedureSeq;
		this.tooth_code = toothCode;
		this.tooth_surface = toothSurface;
		this.tooth_surface_cd_2 = toothSurfaceCd2;
		this.tooth_surface_cd_3 = toothSurfaceCd3;
		this.tooth_surface_cd_4 = toothSurfaceCd4;
		this.tooth_surface_cd_5 = toothSurfaceCd5;
		this.medical_code = procCode;
		this.revenue_code = revenueCode;
		this.description = procCodeDesc;
		this.diagnosis_pointers = diagPointer;
		this.service_from_date = serviceFromDate;
		this.service_to_date = serviceToDate;
		this.billed_amount = billedAmount;
		this.billed_units = billedUnits;
		this.modifier_1 = modifier1;
		this.modifier_2 = modifier2;
		this.modifier_3 = modifier3;
		this.modifier_4 = modifier4;
		this.line_status = lineStatus;
		this.treasury_payment_date = lineItemTreasuryPaymentDateFormatted;
		this.paid_amount = lineItemPaidAmountFormatted;
		this.check_eft_trn = lineItemCheckNumber;
		this.adjustment_amount = lineItemAdjAmts;
		this.group_code = lineItemCagcCodes;
		this.reason_code = lineItemCodes;
		this.remittance_remark_code = lineItemRarcCodes;
	}

	
	/**
	 * @return the claimProcId
	 */
	public Long getClaimProcId() {
		return claimProcId;
	}

	/**
	 * @param claimProcId the claimProcId to set
	 */
	public void setClaimProcId(Long claimProcId) {
		this.claimProcId = claimProcId;
	}

	/**
	 * @return the line_id
	 */
	public Long getLine_id() {
		return line_id;
	}

	/**
	 * @param line_id the line_id to set
	 */
	public void setLine_id(Long line_id) {
		this.line_id = line_id;
	}

	/**
	 * @return the tooth_Code
	 */
	@JsonInclude(JsonInclude.Include.NON_NULL)
	public String getTooth_code() {
		return tooth_code;
	}

	/**
	 * @param tooth_Code the tooth_Code to set
	 */
	public void setTooth_code(String tooth_Code) {
		this.tooth_code = tooth_Code;
	}

	/**
	 * @return the tooth_Surface
	 */
	@JsonInclude(JsonInclude.Include.NON_NULL)
	public String getTooth_surface() {
		return tooth_surface;
	}

	/**
	 * @param tooth_Surface the tooth_Surface to set
	 */
	public void setTooth_surface(String tooth_Surface) {
		this.tooth_surface = tooth_Surface;
	}

	/**
	 * @return the tooth_Surface_Cd_2
	 */
	@JsonInclude(JsonInclude.Include.NON_NULL)
	public String getTooth_surface_cd_2() {
		return tooth_surface_cd_2;
	}

	/**
	 * @param tooth_Surface_Cd_2 the tooth_Surface_Cd_2 to set
	 */
	public void setTooth_surface_cd_2(String tooth_Surface_Cd_2) {
		this.tooth_surface_cd_2 = tooth_Surface_Cd_2;
	}

	/**
	 * @return the tooth_Surface_Cd_3
	 */
	@JsonInclude(JsonInclude.Include.NON_NULL)
	public String getTooth_surface_cd_3() {
		return tooth_surface_cd_3;
	}

	/**
	 * @param tooth_Surface_Cd_3 the tooth_Surface_Cd_3 to set
	 */
	public void setTooth_surface_cd_3(String tooth_Surface_Cd_3) {
		this.tooth_surface_cd_3 = tooth_Surface_Cd_3;
	}

	/**
	 * @return the tooth_Surface_Cd_4
	 */
	@JsonInclude(JsonInclude.Include.NON_NULL)
	public String getTooth_surface_cd_4() {
		return tooth_surface_cd_4;
	}

	/**
	 * @param tooth_Surface_Cd_4 the tooth_Surface_Cd_4 to set
	 */
	public void setTooth_surface_cd_4(String tooth_Surface_Cd_4) {
		this.tooth_surface_cd_4 = tooth_Surface_Cd_4;
	}

	/**
	 * @return the tooth_Surface_Cd_5
	 */
	@JsonInclude(JsonInclude.Include.NON_NULL)
	public String getTooth_surface_cd_5() {
		return tooth_surface_cd_5;
	}

	/**
	 * @param tooth_Surface_Cd_5 the tooth_Surface_Cd_5 to set
	 */
	public void setTooth_surface_cd_5(String tooth_Surface_Cd_5) {
		this.tooth_surface_cd_5 = tooth_Surface_Cd_5;
	}

	/**
	 * @return the oral_Cavity_Cd
	 */
	@JsonInclude(JsonInclude.Include.NON_NULL)
	public String getOral_savity_cd() {
		return oral_cavity_cd;
	}

	/**
	 * @param oral_Cavity_Cd the oral_Cavity_Cd to set
	 */
	public void setOral_cavity_cd(String oral_Cavity_Cd) {
		this.oral_cavity_cd = oral_Cavity_Cd;
	}

	/**
	 * @return the medical_Code
	 */
	public String getMedical_code() {
		return medical_code;
	}

	/**
	 * @param medical_Code the medical_Code to set
	 */
	public void setMedical_code(String medical_Code) {
		this.medical_code = medical_Code;
	}

	/**
	 * @return the revenue_Code
	 */
	@JsonInclude(JsonInclude.Include.NON_NULL)
	public String getRevenue_code() {
		return revenue_code;
	}

	/**
	 * @param revenue_Code the revenue_Code to set
	 */
	public void setRevenue_code(String revenue_Code) {
		this.revenue_code = revenue_Code;
	}

	/**
	 * @return the description
	 */
	@JsonInclude(JsonInclude.Include.NON_NULL)
	public String getDescription() {
		return description;
	}

	/**
	 * @param description the description to set
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * @return the diagnosis_pointers
	 */
	@JsonInclude(JsonInclude.Include.NON_NULL)
	public String getDiagnosis_pointers() {
		return diagnosis_pointers;
	}

	/**
	 * @param diagnosis_pointers the diagnosis_pointers to set
	 */
	public void setDiagnosis_pointers(String diagnosis_pointers) {
		this.diagnosis_pointers = diagnosis_pointers;
	}

	/**
	 * @return the service_from_date
	 */
	public String getService_from_date() {
		return service_from_date;
	}

	/**
	 * @param service_from_date the service_from_date to set
	 */
	public void setService_from_date(String service_from_date) {
		this.service_from_date = service_from_date;
	}

	/**
	 * @return the service_to_date
	 */
	public String getService_to_date() {
		return service_to_date;
	}

	/**
	 * @param service_to_date the service_to_date to set
	 */
	public void setService_to_date(String service_to_date) {
		this.service_to_date = service_to_date;
	}

	/**
	 * @return the billed_amount
	 */
	public String getBilled_amount() {
		return billed_amount;
	}

	/**
	 * @param billed_amount the billed_amount to set
	 */
	public void setBilled_amount(String billed_amount) {
		this.billed_amount = billed_amount;
	}

	/**
	 * @return the billed_units
	 */
	@JsonInclude(JsonInclude.Include.NON_NULL)
	public Long getBilled_units() {
		return billed_units;
	}

	/**
	 * @param billed_units the billed_units to set
	 */
	public void setBilled_units(Long billed_units) {
		this.billed_units = billed_units;
	}

	/**
	 * @return the modifier_1
	 */
	@JsonInclude(JsonInclude.Include.NON_NULL)
	public String getModifier_1() {
		return modifier_1;
	}

	/**
	 * @param modifier_1 the modifier_1 to set
	 */
	public void setModifier_1(String modifier_1) {
		this.modifier_1 = modifier_1;
	}

	/**
	 * @return the modifier_2
	 */
	@JsonInclude(JsonInclude.Include.NON_NULL)
	public String getModifier_2() {
		return modifier_2;
	}

	/**
	 * @param modifier_2 the modifier_2 to set
	 */
	public void setModifier_2(String modifier_2) {
		this.modifier_2 = modifier_2;
	}

	/**
	 * @return the modifier_3
	 */
	@JsonInclude(JsonInclude.Include.NON_NULL)
	public String getModifier_3() {
		return modifier_3;
	}

	/**
	 * @param modifier_3 the modifier_3 to set
	 */
	public void setModifier_3(String modifier_3) {
		this.modifier_3 = modifier_3;
	}

	/**
	 * @return the modifier_4
	 */
	@JsonInclude(JsonInclude.Include.NON_NULL)
	public String getModifier_4() {
		return modifier_4;
	}

	/**
	 * @param modifier_4 the modifier_4 to set
	 */
	public void setModifier_4(String modifier_4) {
		this.modifier_4 = modifier_4;
	}

	/**
	 * @return the line_Status
	 */
	public String getLine_status() {
		return line_status;
	}

	/**
	 * @param line_Status the line_Status to set
	 */
	public void setLine_status(String line_Status) {
		this.line_status = line_Status;
	}

	/**
	 * @return the treasury_payment_date
	 */
	public String getTreasury_payment_date() {
		return treasury_payment_date;
	}

	/**
	 * @param treasury_payment_date the treasury_payment_date to set
	 */
	public void setTreasury_payment_date(String treasury_payment_date) {
		this.treasury_payment_date = treasury_payment_date;
	}

	/**
	 * @return the paid_amount
	 */
	public String getPaid_amount() {
		return paid_amount;
	}

	/**
	 * @param paid_amount the paid_amount to set
	 */
	public void setPaid_amount(String paid_amount) {
		this.paid_amount = paid_amount;
	}

	/**
	 * @return the check_eft_trn
	 */
	public String getCheck_eft_trn() {
		return check_eft_trn;
	}

	/**
	 * @param check_eft_trn the check_eft_trn to set
	 */
	public void setCheck_eft_trn(String check_eft_trn) {
		this.check_eft_trn = check_eft_trn;
	}

	/**
	 * @return the adjustment_amount
	 */
	public String getAdjustment_amount() {
		return adjustment_amount;
	}

	/**
	 * @param adjustment_amount the adjustment_amount to set
	 */
	public void setAdjustment_amount(String adjustment_amount) {
		this.adjustment_amount = adjustment_amount;
	}

	/**
	 * @return the group_code
	 */
	public String getGroup_code() {
		return group_code;
	}

	/**
	 * @param group_code the group_code to set
	 */
	public void setGroup_code(String group_code) {
		this.group_code = group_code;
	}

	/**
	 * @return the reason_code
	 */
	public String getReason_code() {
		return reason_code;
	}

	/**
	 * @param reason_code the reason_code to set
	 */
	public void setReason_code(String reason_code) {
		this.reason_code = reason_code;
	}
	
	/**
	 * @return the remittance_remark_code
	 */
	public String getRemittance_remark_code() {
		return remittance_remark_code;
	}

	/**
	 * @param remittance_remark_code the remittance_remark_code to set
	 */
	public void setRemittance_remark_code(String remittance_remark_code) {
		this.remittance_remark_code = remittance_remark_code;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((adjustment_amount == null) ? 0 : adjustment_amount.hashCode());
		result = prime * result + ((billed_amount == null) ? 0 : billed_amount.hashCode());
		result = prime * result + ((billed_units == null) ? 0 : billed_units.hashCode());
		result = prime * result + ((check_eft_trn == null) ? 0 : check_eft_trn.hashCode());
		result = prime * result + ((description == null) ? 0 : description.hashCode());
		result = prime * result + ((diagnosis_pointers == null) ? 0 : diagnosis_pointers.hashCode());
		result = prime * result + ((group_code == null) ? 0 : group_code.hashCode());
		result = prime * result + ((line_id == null) ? 0 : line_id.hashCode());
		result = prime * result + ((line_status == null) ? 0 : line_status.hashCode());
		result = prime * result + ((medical_code == null) ? 0 : medical_code.hashCode());
		result = prime * result + ((modifier_1 == null) ? 0 : modifier_1.hashCode());
		result = prime * result + ((modifier_2 == null) ? 0 : modifier_2.hashCode());
		result = prime * result + ((modifier_3 == null) ? 0 : modifier_3.hashCode());
		result = prime * result + ((modifier_4 == null) ? 0 : modifier_4.hashCode());
		result = prime * result + ((oral_cavity_cd == null) ? 0 : oral_cavity_cd.hashCode());
		result = prime * result + ((paid_amount == null) ? 0 : paid_amount.hashCode());
		result = prime * result + ((reason_code == null) ? 0 : reason_code.hashCode());
		result = prime * result + ((remittance_remark_code == null) ? 0 : remittance_remark_code.hashCode());
		result = prime * result + ((revenue_code == null) ? 0 : revenue_code.hashCode());
		result = prime * result + ((service_from_date == null) ? 0 : service_from_date.hashCode());
		result = prime * result + ((service_to_date == null) ? 0 : service_to_date.hashCode());
		result = prime * result + ((tooth_code == null) ? 0 : tooth_code.hashCode());
		result = prime * result + ((tooth_surface == null) ? 0 : tooth_surface.hashCode());
		result = prime * result + ((tooth_surface_cd_2 == null) ? 0 : tooth_surface_cd_2.hashCode());
		result = prime * result + ((tooth_surface_cd_3 == null) ? 0 : tooth_surface_cd_3.hashCode());
		result = prime * result + ((tooth_surface_cd_4 == null) ? 0 : tooth_surface_cd_4.hashCode());
		result = prime * result + ((tooth_surface_cd_5 == null) ? 0 : tooth_surface_cd_5.hashCode());
		result = prime * result + ((treasury_payment_date == null) ? 0 : treasury_payment_date.hashCode());
		return result;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		LineItemResponse other = (LineItemResponse) obj;
		if (adjustment_amount == null) {
			if (other.adjustment_amount != null)
				return false;
		} else if (!adjustment_amount.equals(other.adjustment_amount))
			return false;
		if (billed_amount == null) {
			if (other.billed_amount != null)
				return false;
		} else if (!billed_amount.equals(other.billed_amount))
			return false;
		if (billed_units == null) {
			if (other.billed_units != null)
				return false;
		} else if (!billed_units.equals(other.billed_units))
			return false;
		if (check_eft_trn == null) {
			if (other.check_eft_trn != null)
				return false;
		} else if (!check_eft_trn.equals(other.check_eft_trn))
			return false;
		if (description == null) {
			if (other.description != null)
				return false;
		} else if (!description.equals(other.description))
			return false;
		if (diagnosis_pointers == null) {
			if (other.diagnosis_pointers != null)
				return false;
		} else if (!diagnosis_pointers.equals(other.diagnosis_pointers))
			return false;
		if (group_code == null) {
			if (other.group_code != null)
				return false;
		} else if (!group_code.equals(other.group_code))
			return false;
		if (line_id == null) {
			if (other.line_id != null)
				return false;
		} else if (!line_id.equals(other.line_id))
			return false;
		if (line_status == null) {
			if (other.line_status != null)
				return false;
		} else if (!line_status.equals(other.line_status))
			return false;
		if (medical_code == null) {
			if (other.medical_code != null)
				return false;
		} else if (!medical_code.equals(other.medical_code))
			return false;
		if (modifier_1 == null) {
			if (other.modifier_1 != null)
				return false;
		} else if (!modifier_1.equals(other.modifier_1))
			return false;
		if (modifier_2 == null) {
			if (other.modifier_2 != null)
				return false;
		} else if (!modifier_2.equals(other.modifier_2))
			return false;
		if (modifier_3 == null) {
			if (other.modifier_3 != null)
				return false;
		} else if (!modifier_3.equals(other.modifier_3))
			return false;
		if (modifier_4 == null) {
			if (other.modifier_4 != null)
				return false;
		} else if (!modifier_4.equals(other.modifier_4))
			return false;
		if (oral_cavity_cd == null) {
			if (other.oral_cavity_cd != null)
				return false;
		} else if (!oral_cavity_cd.equals(other.oral_cavity_cd))
			return false;
		if (paid_amount == null) {
			if (other.paid_amount != null)
				return false;
		} else if (!paid_amount.equals(other.paid_amount))
			return false;
		if (reason_code == null) {
			if (other.reason_code != null)
				return false;
		} else if (!reason_code.equals(other.reason_code))
			return false;
		if (remittance_remark_code == null) {
			if (other.remittance_remark_code != null)
				return false;
		} else if (!remittance_remark_code.equals(other.remittance_remark_code))
			return false;
		if (revenue_code == null) {
			if (other.revenue_code != null)
				return false;
		} else if (!revenue_code.equals(other.revenue_code))
			return false;
		if (service_from_date == null) {
			if (other.service_from_date != null)
				return false;
		} else if (!service_from_date.equals(other.service_from_date))
			return false;
		if (service_to_date == null) {
			if (other.service_to_date != null)
				return false;
		} else if (!service_to_date.equals(other.service_to_date))
			return false;
		if (tooth_code == null) {
			if (other.tooth_code != null)
				return false;
		} else if (!tooth_code.equals(other.tooth_code))
			return false;
		if (tooth_surface == null) {
			if (other.tooth_surface != null)
				return false;
		} else if (!tooth_surface.equals(other.tooth_surface))
			return false;
		if (tooth_surface_cd_2 == null) {
			if (other.tooth_surface_cd_2 != null)
				return false;
		} else if (!tooth_surface_cd_2.equals(other.tooth_surface_cd_2))
			return false;
		if (tooth_surface_cd_3 == null) {
			if (other.tooth_surface_cd_3 != null)
				return false;
		} else if (!tooth_surface_cd_3.equals(other.tooth_surface_cd_3))
			return false;
		if (tooth_surface_cd_4 == null) {
			if (other.tooth_surface_cd_4 != null)
				return false;
		} else if (!tooth_surface_cd_4.equals(other.tooth_surface_cd_4))
			return false;
		if (tooth_surface_cd_5 == null) {
			if (other.tooth_surface_cd_5 != null)
				return false;
		} else if (!tooth_surface_cd_5.equals(other.tooth_surface_cd_5))
			return false;
		if (treasury_payment_date == null) {
			if (other.treasury_payment_date != null)
				return false;
		} else if (!treasury_payment_date.equals(other.treasury_payment_date))
			return false;
		return true;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "LineItemResponse [line_id=" + line_id + ", tooth_code=" + tooth_code + ", tooth_surface="
				+ tooth_surface + ", tooth_surface_cd_2=" + tooth_surface_cd_2 + ", tooth_surface_cd_3="
				+ tooth_surface_cd_3 + ", tooth_surface_cd_4=" + tooth_surface_cd_4 + ", tooth_surface_cd_5="
				+ tooth_surface_cd_5 + ", oral_cavity_cd=" + oral_cavity_cd + ", medical_code=" + medical_code
				+ ", revenue_code=" + revenue_code + ", description=" + description + ", diagnosis_pointers="
				+ diagnosis_pointers + ", service_from_date=" + service_from_date + ", service_to_date="
				+ service_to_date + ", billed_amount=" + billed_amount + ", billed_units=" + billed_units
				+ ", modifier_1=" + modifier_1 + ", modifier_2=" + modifier_2 + ", modifier_3=" + modifier_3
				+ ", modifier_4=" + modifier_4 + ", line_status=" + line_status + ", treasury_payment_date="
				+ treasury_payment_date + ", paid_amount=" + paid_amount + ", check_eft_trn=" + check_eft_trn
				+ ", adjustment_amount=" + adjustment_amount + ", reason_code=" + reason_code + ", group_code="
				+ group_code + ", remittance_remark_code=" + remittance_remark_code + "]";
	}
	
}

	
