/**
 * 
 */
package gov.va.med.fee.model.response;

/**
 * @author Vamsi Krishna Gangarapu
 *
 */
public class DiagnosisCodes {

	private int sequenceNumber;
    private String diagnosisCode;
    private String diagnosisCodeQualifier;
    private String poaIndicator;
    private String diagnosisDescription;
    
	/**
	 * 
	 */
	public DiagnosisCodes() {
	}
	
	/**
	 * @param sequenceNumber
	 * @param diagnosisCode
	 * @param diagnosisCodeQualifier
	 * @param poaIndicator
	 * @param diagnosisDescription
	 */
	public DiagnosisCodes(int sequenceNumber, String diagnosisCode, String diagnosisCodeQualifier, String poaIndicator,
			String diagnosisDescription) {
		super();
		this.sequenceNumber = sequenceNumber;
		this.diagnosisCode = diagnosisCode;
		this.diagnosisCodeQualifier = diagnosisCodeQualifier;
		this.poaIndicator = poaIndicator;
		this.diagnosisDescription = diagnosisDescription;
	}

	/**
	 * @return the sequenceNumber
	 */
	public int getSequenceNumber() {
		return sequenceNumber;
	}

	/**
	 * @param sequenceNumber the sequenceNumber to set
	 */
	public void setSequenceNumber(int sequenceNumber) {
		this.sequenceNumber = sequenceNumber;
	}

	/**
	 * @return the diagnosisCode
	 */
	public String getDiagnosisCode() {
		return diagnosisCode;
	}

	/**
	 * @param diagnosisCode the diagnosisCode to set
	 */
	public void setDiagnosisCode(String diagnosisCode) {
		this.diagnosisCode = diagnosisCode;
	}

	/**
	 * @return the diagnosisCodeQualifier
	 */
	public String getDiagnosisCodeQualifier() {
		return diagnosisCodeQualifier;
	}

	/**
	 * @param diagnosisCodeQualifier the diagnosisCodeQualifier to set
	 */
	public void setDiagnosisCodeQualifier(String diagnosisCodeQualifier) {
		this.diagnosisCodeQualifier = diagnosisCodeQualifier;
	}

	/**
	 * @return the poaIndicator
	 */
	public String getPoaIndicator() {
		return poaIndicator;
	}

	/**
	 * @param poaIndicator the poaIndicator to set
	 */
	public void setPoaIndicator(String poaIndicator) {
		this.poaIndicator = poaIndicator;
	}

	/**
	 * @return the diagnosisDescription
	 */
	public String getDiagnosisDescription() {
		return diagnosisDescription;
	}

	/**
	 * @param diagnosisDescription the diagnosisDescription to set
	 */
	public void setDiagnosisDescription(String diagnosisDescription) {
		this.diagnosisDescription = diagnosisDescription;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((diagnosisCode == null) ? 0 : diagnosisCode.hashCode());
		result = prime * result + ((diagnosisCodeQualifier == null) ? 0 : diagnosisCodeQualifier.hashCode());
		result = prime * result + ((diagnosisDescription == null) ? 0 : diagnosisDescription.hashCode());
		result = prime * result + ((poaIndicator == null) ? 0 : poaIndicator.hashCode());
		result = prime * result + sequenceNumber;
		return result;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		DiagnosisCodes other = (DiagnosisCodes) obj;
		if (diagnosisCode == null) {
			if (other.diagnosisCode != null)
				return false;
		} else if (!diagnosisCode.equals(other.diagnosisCode))
			return false;
		if (diagnosisCodeQualifier == null) {
			if (other.diagnosisCodeQualifier != null)
				return false;
		} else if (!diagnosisCodeQualifier.equals(other.diagnosisCodeQualifier))
			return false;
		if (diagnosisDescription == null) {
			if (other.diagnosisDescription != null)
				return false;
		} else if (!diagnosisDescription.equals(other.diagnosisDescription))
			return false;
		if (poaIndicator == null) {
			if (other.poaIndicator != null)
				return false;
		} else if (!poaIndicator.equals(other.poaIndicator))
			return false;
		if (sequenceNumber != other.sequenceNumber)
			return false;
		return true;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("DiagnosisCodes [sequenceNumber=");
		builder.append(sequenceNumber);
		builder.append(", diagnosisCode=");
		builder.append(diagnosisCode);
		builder.append(", diagnosisCodeQualifier=");
		builder.append(diagnosisCodeQualifier);
		builder.append(", poaIndicator=");
		builder.append(poaIndicator);
		builder.append(", diagnosisDescription=");
		builder.append(diagnosisDescription);
		builder.append("]");
		return builder.toString();
	}

}
