/**
 * 
 */
package gov.va.med.fee.model.response;

/**
 * @author Vamsi Krishna Gangarapu
 *
 */
public class CodeLookupResponse {

	String codeType;
	String code;
	String description;
	String drugExempt;
	String startDate;
	String expirationDate;
	public CodeLookupResponse() {
		super();
		// TODO Auto-generated constructor stub
	}

	public CodeLookupResponse(String codeType, String code, String description, String drugExempt, String startDate,
			String expirationDate) {
		super();
		this.codeType = codeType;
		this.code = code;
		this.description = description;
		this.drugExempt = drugExempt;
		this.startDate = startDate;
		this.expirationDate = expirationDate;
	}

	/**
	 * @return the codeType
	 */
	public String getCodeType() {
		return codeType;
	}

	/**
	 * @param codeType the codeType to set
	 */
	public void setCodeType(String codeType) {
		this.codeType = codeType;
	}

	/**
	 * @return the code
	 */
	public String getCode() {
		return code;
	}

	/**
	 * @param code the code to set
	 */
	public void setCode(String code) {
		this.code = code;
	}

	/**
	 * @return the description
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * @param description the description to set
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * @return the drugExempt
	 */
	public String getDrugExempt() {
		return drugExempt;
	}

	/**
	 * @param drugExempt the drugExempt to set
	 */
	public void setDrugExempt(String drugExempt) {
		this.drugExempt = drugExempt;
	}

	/**
	 * @return the startDate
	 */
	public String getStartDate() {
		return startDate;
	}

	/**
	 * @param startDate the startDate to set
	 */
	public void setStartDate(String startDate) {
		this.startDate = startDate;
	}

	/**
	 * @return the expirationDate
	 */
	public String getExpirationDate() {
		return expirationDate;
	}

	/**
	 * @param expirationDate the expirationDate to set
	 */
	public void setExpirationDate(String expirationDate) {
		this.expirationDate = expirationDate;
	}
	
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("MedicalCodeResponse [codeType=");
		builder.append(codeType);
		builder.append(", medicalCode=");
		builder.append(code);
		builder.append(", medicalCodeDescription=");
		builder.append(description);
		builder.append(", drugExempt=");
		builder.append(drugExempt);
		builder.append(", startDate=");
		builder.append(startDate);
		builder.append(", expirationDate=");
		builder.append(expirationDate);
		builder.append("]");
		return builder.toString();
	}
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((codeType == null) ? 0 : codeType.hashCode());
		result = prime * result + ((drugExempt == null) ? 0 : drugExempt.hashCode());
		result = prime * result + ((expirationDate == null) ? 0 : expirationDate.hashCode());
		result = prime * result + ((code == null) ? 0 : code.hashCode());
		result = prime * result + ((description == null) ? 0 : description.hashCode());
		result = prime * result + ((startDate == null) ? 0 : startDate.hashCode());
		return result;
	}
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		CodeLookupResponse other = (CodeLookupResponse) obj;
		if (codeType == null) {
			if (other.codeType != null)
				return false;
		} else if (!codeType.equals(other.codeType))
			return false;
		if (drugExempt == null) {
			if (other.drugExempt != null)
				return false;
		} else if (!drugExempt.equals(other.drugExempt))
			return false;
		if (expirationDate == null) {
			if (other.expirationDate != null)
				return false;
		} else if (!expirationDate.equals(other.expirationDate))
			return false;
		if (code == null) {
			if (other.code != null)
				return false;
		} else if (!code.equals(other.code))
			return false;
		if (description == null) {
			if (other.description != null)
				return false;
		} else if (!description.equals(other.description))
			return false;
		if (startDate == null) {
			if (other.startDate != null)
				return false;
		} else if (!startDate.equals(other.startDate))
			return false;
		return true;
	}

}
