/*
 * $Id: ClaimRejectionHistoryEntity.java,v 1.1 2009/09/03 22:22:52 vhahacdoansc Exp $
 */
package gov.va.med.fee.model.response;

import java.util.Date;

import org.springframework.stereotype.Component;

/**
 * The class ClaimRejectionHistoryEntity class holds data about the 
 * rejection history of a claim.
 */
/**
 * @author Vamsi Krishna Gangarapu
 *
 */
@Component
public class ClaimRejectionHistoryResponse {

    private Date date;
    private String rejectedBy;
    private String reason;
    private String explanation;
    private String reviewedBy;
    private String outcome;
    private String reviewerComments;
	/**
	 * 
	 */
	public ClaimRejectionHistoryResponse() {
	}
	/**
	 * @param date
	 * @param rejectedBy
	 * @param reason
	 * @param explanation
	 * @param reviewedBy
	 * @param outcome
	 * @param reviewerComents
	 */
	public ClaimRejectionHistoryResponse(Date date, String rejectedBy, String reason, String explanation,
			String reviewedBy, String outcome, String reviewerComments) {
		super();
		this.date = date;
		this.rejectedBy = rejectedBy;
		this.reason = reason;
		this.explanation = explanation;
		this.reviewedBy = reviewedBy;
		this.outcome = outcome;
		this.reviewerComments = reviewerComments;
	}
	/**
	 * @return the date
	 */
	public Date getDate() {
		return date;
	}
	/**
	 * @param date the date to set
	 */
	public void setDate(Date date) {
		this.date = date;
	}
	/**
	 * @return the rejectedBy
	 */
	public String getRejectedBy() {
		return rejectedBy;
	}
	/**
	 * @param rejectedBy the rejectedBy to set
	 */
	public void setRejectedBy(String rejectedBy) {
		this.rejectedBy = rejectedBy;
	}
	/**
	 * @return the reason
	 */
	public String getReason() {
		return reason;
	}
	/**
	 * @param reason the reason to set
	 */
	public void setReason(String reason) {
		this.reason = reason;
	}
	/**
	 * @return the explanation
	 */
	public String getExplanation() {
		return explanation;
	}
	/**
	 * @param explanation the explanation to set
	 */
	public void setExplanation(String explanation) {
		this.explanation = explanation;
	}
	/**
	 * @return the reviewedBy
	 */
	public String getReviewedBy() {
		return reviewedBy;
	}
	/**
	 * @param reviewedBy the reviewedBy to set
	 */
	public void setReviewedBy(String reviewedBy) {
		this.reviewedBy = reviewedBy;
	}
	/**
	 * @return the outcome
	 */
	public String getOutcome() {
		return outcome;
	}
	/**
	 * @param outcome the outcome to set
	 */
	public void setOutcome(String outcome) {
		this.outcome = outcome;
	}
	/**
	 * @return the reviewerComents
	 */
	public String getReviewerComments() {
		return reviewerComments;
	}
	/**
	 * @param reviewerComents the reviewerComents to set
	 */
	public void setReviewerComents(String reviewerComments) {
		this.reviewerComments = reviewerComments;
	}
	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((date == null) ? 0 : date.hashCode());
		result = prime * result + ((explanation == null) ? 0 : explanation.hashCode());
		result = prime * result + ((outcome == null) ? 0 : outcome.hashCode());
		result = prime * result + ((reason == null) ? 0 : reason.hashCode());
		result = prime * result + ((rejectedBy == null) ? 0 : rejectedBy.hashCode());
		result = prime * result + ((reviewedBy == null) ? 0 : reviewedBy.hashCode());
		result = prime * result + ((reviewerComments == null) ? 0 : reviewerComments.hashCode());
		return result;
	}
	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		ClaimRejectionHistoryResponse other = (ClaimRejectionHistoryResponse) obj;
		if (date == null) {
			if (other.date != null)
				return false;
		} else if (!date.equals(other.date))
			return false;
		if (explanation == null) {
			if (other.explanation != null)
				return false;
		} else if (!explanation.equals(other.explanation))
			return false;
		if (outcome == null) {
			if (other.outcome != null)
				return false;
		} else if (!outcome.equals(other.outcome))
			return false;
		if (reason == null) {
			if (other.reason != null)
				return false;
		} else if (!reason.equals(other.reason))
			return false;
		if (rejectedBy == null) {
			if (other.rejectedBy != null)
				return false;
		} else if (!rejectedBy.equals(other.rejectedBy))
			return false;
		if (reviewedBy == null) {
			if (other.reviewedBy != null)
				return false;
		} else if (!reviewedBy.equals(other.reviewedBy))
			return false;
		if (reviewerComments == null) {
			if (other.reviewerComments != null)
				return false;
		} else if (!reviewerComments.equals(other.reviewerComments))
			return false;
		return true;
	}
	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("ClaimRejectionHistoryResponse [date=");
		builder.append(date);
		builder.append(", rejectedBy=");
		builder.append(rejectedBy);
		builder.append(", reason=");
		builder.append(reason);
		builder.append(", explanation=");
		builder.append(explanation);
		builder.append(", reviewedBy=");
		builder.append(reviewedBy);
		builder.append(", outcome=");
		builder.append(outcome);
		builder.append(", reviewerComments=");
		builder.append(reviewerComments);
		builder.append("]");
		return builder.toString();
	}
  
    
	
   
}
